<?php
/**
 * The template to display the widgets area in the header
 *
 * @package NEURONET
 * @since NEURONET 1.0
 */

// Header sidebar
$neuronet_header_name    = neuronet_get_theme_option( 'header_widgets' );
$neuronet_header_present = ! neuronet_is_off( $neuronet_header_name ) && is_active_sidebar( $neuronet_header_name );
if ( $neuronet_header_present ) {
	neuronet_storage_set( 'current_sidebar', 'header' );
	$neuronet_header_wide = neuronet_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $neuronet_header_name ) ) {
		dynamic_sidebar( $neuronet_header_name );
	}
	$neuronet_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $neuronet_widgets_output ) ) {
		$neuronet_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $neuronet_widgets_output );
		$neuronet_need_columns   = strpos( $neuronet_widgets_output, 'columns_wrap' ) === false;
		if ( $neuronet_need_columns ) {
			$neuronet_columns = max( 0, (int) neuronet_get_theme_option( 'header_columns' ) );
			if ( 0 == $neuronet_columns ) {
				$neuronet_columns = min( 6, max( 1, neuronet_tags_count( $neuronet_widgets_output, 'aside' ) ) );
			}
			if ( $neuronet_columns > 1 ) {
				$neuronet_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $neuronet_columns ) . ' widget', $neuronet_widgets_output );
			} else {
				$neuronet_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $neuronet_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'neuronet_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $neuronet_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $neuronet_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'neuronet_action_before_sidebar', 'header' );
				neuronet_show_layout( $neuronet_widgets_output );
				do_action( 'neuronet_action_after_sidebar', 'header' );
				if ( $neuronet_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $neuronet_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'neuronet_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
