<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package NEURONET
 * @since NEURONET 1.0
 */

// Page (category, tag, archive, author) title

if ( neuronet_need_page_title() ) {
	neuronet_sc_layouts_showed( 'title', true );
	neuronet_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								neuronet_show_post_meta(
									apply_filters(
										'neuronet_filter_post_meta_args', array(
											'components' => join( ',', neuronet_array_get_keys_by_value( neuronet_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', neuronet_array_get_keys_by_value( neuronet_get_theme_option( 'counters' ) ) ),
											'seo'        => neuronet_is_on( neuronet_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$neuronet_blog_title           = neuronet_get_blog_title();
							$neuronet_blog_title_text      = '';
							$neuronet_blog_title_class     = '';
							$neuronet_blog_title_link      = '';
							$neuronet_blog_title_link_text = '';
							if ( is_array( $neuronet_blog_title ) ) {
								$neuronet_blog_title_text      = $neuronet_blog_title['text'];
								$neuronet_blog_title_class     = ! empty( $neuronet_blog_title['class'] ) ? ' ' . $neuronet_blog_title['class'] : '';
								$neuronet_blog_title_link      = ! empty( $neuronet_blog_title['link'] ) ? $neuronet_blog_title['link'] : '';
								$neuronet_blog_title_link_text = ! empty( $neuronet_blog_title['link_text'] ) ? $neuronet_blog_title['link_text'] : '';
							} else {
								$neuronet_blog_title_text = $neuronet_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $neuronet_blog_title_class ); ?>">
								<?php
								$neuronet_top_icon = neuronet_get_term_image_small();
								if ( ! empty( $neuronet_top_icon ) ) {
									$neuronet_attr = neuronet_getimagesize( $neuronet_top_icon );
									?>
									<img src="<?php echo esc_url( $neuronet_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'neuronet' ); ?>"
										<?php
										if ( ! empty( $neuronet_attr[3] ) ) {
											neuronet_show_layout( $neuronet_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $neuronet_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $neuronet_blog_title_link ) && ! empty( $neuronet_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $neuronet_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $neuronet_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'neuronet_action_breadcrumbs' );
						$neuronet_breadcrumbs = ob_get_contents();
						ob_end_clean();
						neuronet_show_layout( $neuronet_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
