<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package NEURONET
 * @since NEURONET 1.0
 */

$neuronet_args = get_query_var( 'neuronet_logo_args' );

// Site logo
$neuronet_logo_type   = isset( $neuronet_args['type'] ) ? $neuronet_args['type'] : '';
$neuronet_logo_image  = neuronet_get_logo_image( $neuronet_logo_type );
$neuronet_logo_text   = neuronet_is_on( neuronet_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$neuronet_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $neuronet_logo_image['logo'] ) || ! empty( $neuronet_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $neuronet_logo_image['logo'] ) ) {
            if ( empty( $neuronet_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($neuronet_logo_image['logo']) && (int) $neuronet_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$neuronet_attr = neuronet_getimagesize( $neuronet_logo_image['logo'] );
				echo '<img src="' . esc_url( $neuronet_logo_image['logo'] ) . '"'
						. ( ! empty( $neuronet_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $neuronet_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $neuronet_logo_text ) . '"'
						. ( ! empty( $neuronet_attr[3] ) ? ' ' . wp_kses_data( $neuronet_attr[3] ) : '' )
						. '>';
			}
		} else {
			neuronet_show_layout( neuronet_prepare_macros( $neuronet_logo_text ), '<span class="logo_text">', '</span>' );
			neuronet_show_layout( neuronet_prepare_macros( $neuronet_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
