<?php
/**
 * The template to display default site header
 *
 * @package NEURONET
 * @since NEURONET 1.0
 */

$neuronet_header_css   = '';
$neuronet_header_image = get_header_image();
$neuronet_header_video = neuronet_get_header_video();
if ( ! empty( $neuronet_header_image ) && neuronet_trx_addons_featured_image_override( is_singular() || neuronet_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$neuronet_header_image = neuronet_get_current_mode_image( $neuronet_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $neuronet_header_image ) || ! empty( $neuronet_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $neuronet_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $neuronet_header_image ) {
		echo ' ' . esc_attr( neuronet_add_inline_css_class( 'background-image: url(' . esc_url( $neuronet_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( neuronet_is_on( neuronet_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight neuronet-full-height';
	}
	$neuronet_header_scheme = neuronet_get_theme_option( 'header_scheme' );
	if ( ! empty( $neuronet_header_scheme ) && ! neuronet_is_inherit( $neuronet_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $neuronet_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $neuronet_header_video ) ) {
		get_template_part( apply_filters( 'neuronet_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'neuronet_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( neuronet_is_on( neuronet_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'neuronet_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'neuronet_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'neuronet_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
