<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package NEURONET
 * @since NEURONET 1.0.06
 */

$neuronet_header_css   = '';
$neuronet_header_image = get_header_image();
$neuronet_header_video = neuronet_get_header_video();
if ( ! empty( $neuronet_header_image ) && neuronet_trx_addons_featured_image_override( is_singular() || neuronet_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$neuronet_header_image = neuronet_get_current_mode_image( $neuronet_header_image );
}

$neuronet_header_id = neuronet_get_custom_header_id();
$neuronet_header_meta = get_post_meta( $neuronet_header_id, 'trx_addons_options', true );
if ( ! empty( $neuronet_header_meta['margin'] ) ) {
	neuronet_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( neuronet_prepare_css_value( $neuronet_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $neuronet_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $neuronet_header_id ) ) ); ?>
				<?php
				echo ! empty( $neuronet_header_image ) || ! empty( $neuronet_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $neuronet_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $neuronet_header_image ) {
					echo ' ' . esc_attr( neuronet_add_inline_css_class( 'background-image: url(' . esc_url( $neuronet_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( neuronet_is_on( neuronet_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight neuronet-full-height';
				}
				$neuronet_header_scheme = neuronet_get_theme_option( 'header_scheme' );
				if ( ! empty( $neuronet_header_scheme ) && ! neuronet_is_inherit( $neuronet_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $neuronet_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $neuronet_header_video ) ) {
		get_template_part( apply_filters( 'neuronet_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'neuronet_action_show_layout', $neuronet_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'neuronet_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
