<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package NEURONET
 * @since NEURONET 1.0.10
 */

// Footer sidebar
$neuronet_footer_name    = neuronet_get_theme_option( 'footer_widgets' );
$neuronet_footer_present = ! neuronet_is_off( $neuronet_footer_name ) && is_active_sidebar( $neuronet_footer_name );
if ( $neuronet_footer_present ) {
	neuronet_storage_set( 'current_sidebar', 'footer' );
	$neuronet_footer_wide = neuronet_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $neuronet_footer_name ) ) {
		dynamic_sidebar( $neuronet_footer_name );
	}
	$neuronet_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $neuronet_out ) ) {
		$neuronet_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $neuronet_out );
		$neuronet_need_columns = true;   //or check: strpos($neuronet_out, 'columns_wrap')===false;
		if ( $neuronet_need_columns ) {
			$neuronet_columns = max( 0, (int) neuronet_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $neuronet_columns ) {
				$neuronet_columns = min( 4, max( 1, neuronet_tags_count( $neuronet_out, 'aside' ) ) );
			}
			if ( $neuronet_columns > 1 ) {
				$neuronet_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $neuronet_columns ) . ' widget', $neuronet_out );
			} else {
				$neuronet_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $neuronet_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'neuronet_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $neuronet_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $neuronet_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'neuronet_action_before_sidebar', 'footer' );
				neuronet_show_layout( $neuronet_out );
				do_action( 'neuronet_action_after_sidebar', 'footer' );
				if ( $neuronet_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $neuronet_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'neuronet_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
