<?php
/**
 * The template to display the site logo in the footer
 *
 * @package NEURONET
 * @since NEURONET 1.0.10
 */

// Logo
if ( neuronet_is_on( neuronet_get_theme_option( 'logo_in_footer' ) ) ) {
	$neuronet_logo_image = neuronet_get_logo_image( 'footer' );
	$neuronet_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $neuronet_logo_image['logo'] ) || ! empty( $neuronet_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $neuronet_logo_image['logo'] ) ) {
					$neuronet_attr = neuronet_getimagesize( $neuronet_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $neuronet_logo_image['logo'] ) . '"'
								. ( ! empty( $neuronet_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $neuronet_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'neuronet' ) . '"'
								. ( ! empty( $neuronet_attr[3] ) ? ' ' . wp_kses_data( $neuronet_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $neuronet_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $neuronet_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
