<?php
/**
 * The template to display default site footer
 *
 * @package NEURONET
 * @since NEURONET 1.0.10
 */

$neuronet_footer_id = neuronet_get_custom_footer_id();
$neuronet_footer_meta = get_post_meta( $neuronet_footer_id, 'trx_addons_options', true );
if ( ! empty( $neuronet_footer_meta['margin'] ) ) {
	neuronet_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( neuronet_prepare_css_value( $neuronet_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $neuronet_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $neuronet_footer_id ) ) ); ?>
						<?php
						$neuronet_footer_scheme = neuronet_get_theme_option( 'footer_scheme' );
						if ( ! empty( $neuronet_footer_scheme ) && ! neuronet_is_inherit( $neuronet_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $neuronet_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'neuronet_action_show_layout', $neuronet_footer_id );
	?>
</footer><!-- /.footer_wrap -->
