<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package NEURONET
 * @since NEURONET 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$neuronet_copyright_scheme = neuronet_get_theme_option( 'copyright_scheme' );
if ( ! empty( $neuronet_copyright_scheme ) && ! neuronet_is_inherit( $neuronet_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $neuronet_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$neuronet_copyright = neuronet_get_theme_option( 'copyright' );
			if ( ! empty( $neuronet_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$neuronet_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $neuronet_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$neuronet_copyright = neuronet_prepare_macros( $neuronet_copyright );
				// Display copyright
				echo wp_kses( nl2br( $neuronet_copyright ), 'neuronet_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
