<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package NEURONET
 * @since NEURONET 1.0
 */

$neuronet_template_args = get_query_var( 'neuronet_template_args' );
if ( is_array( $neuronet_template_args ) ) {
	$neuronet_columns    = empty( $neuronet_template_args['columns'] ) ? 2 : max( 1, $neuronet_template_args['columns'] );
	$neuronet_blog_style = array( $neuronet_template_args['type'], $neuronet_columns );
    $neuronet_columns_class = neuronet_get_column_class( 1, $neuronet_columns, ! empty( $neuronet_template_args['columns_tablet']) ? $neuronet_template_args['columns_tablet'] : '', ! empty($neuronet_template_args['columns_mobile']) ? $neuronet_template_args['columns_mobile'] : '' );
} else {
	$neuronet_blog_style = explode( '_', neuronet_get_theme_option( 'blog_style' ) );
	$neuronet_columns    = empty( $neuronet_blog_style[1] ) ? 2 : max( 1, $neuronet_blog_style[1] );
    $neuronet_columns_class = neuronet_get_column_class( 1, $neuronet_columns );
}

$neuronet_post_format = get_post_format();
$neuronet_post_format = empty( $neuronet_post_format ) ? 'standard' : str_replace( 'post-format-', '', $neuronet_post_format );

?><div class="
<?php
if ( ! empty( $neuronet_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( neuronet_is_blog_style_use_masonry( $neuronet_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $neuronet_columns ) : esc_attr( $neuronet_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $neuronet_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $neuronet_columns )
		. ( 'portfolio' != $neuronet_blog_style[0] ? ' ' . esc_attr( $neuronet_blog_style[0] )  . '_' . esc_attr( $neuronet_columns ) : '' )
	);
	neuronet_add_blog_animation( $neuronet_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$neuronet_hover   = ! empty( $neuronet_template_args['hover'] ) && ! neuronet_is_inherit( $neuronet_template_args['hover'] )
								? $neuronet_template_args['hover']
								: neuronet_get_theme_option( 'image_hover' );

	if ( 'dots' == $neuronet_hover ) {
		$neuronet_post_link = empty( $neuronet_template_args['no_links'] )
								? ( ! empty( $neuronet_template_args['link'] )
									? $neuronet_template_args['link']
									: get_permalink()
									)
								: '';
		$neuronet_target    = ! empty( $neuronet_post_link ) && false === strpos( $neuronet_post_link, home_url() )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$neuronet_components = ! empty( $neuronet_template_args['meta_parts'] )
							? ( is_array( $neuronet_template_args['meta_parts'] )
								? $neuronet_template_args['meta_parts']
								: explode( ',', $neuronet_template_args['meta_parts'] )
								)
							: neuronet_array_get_keys_by_value( neuronet_get_theme_option( 'meta_parts' ) );

	// Featured image
	neuronet_show_post_featured( apply_filters( 'neuronet_filter_args_featured',
        array(
			'hover'         => $neuronet_hover,
			'no_links'      => ! empty( $neuronet_template_args['no_links'] ),
			'thumb_size'    => ! empty( $neuronet_template_args['thumb_size'] )
								? $neuronet_template_args['thumb_size']
								: neuronet_get_thumb_size(
									neuronet_is_blog_style_use_masonry( $neuronet_blog_style[0] )
										? (	strpos( neuronet_get_theme_option( 'body_style' ), 'full' ) !== false || $neuronet_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( neuronet_get_theme_option( 'body_style' ), 'full' ) !== false || $neuronet_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => neuronet_is_blog_style_use_masonry( $neuronet_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $neuronet_components,
			'class'         => 'dots' == $neuronet_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $neuronet_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $neuronet_post_link )
												? '<a href="' . esc_url( $neuronet_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $neuronet_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $neuronet_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $neuronet_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!