<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package NEURONET
 * @since NEURONET 1.0
 */

$neuronet_template_args = get_query_var( 'neuronet_template_args' );
$neuronet_columns = 1;
if ( is_array( $neuronet_template_args ) ) {
	$neuronet_columns    = empty( $neuronet_template_args['columns'] ) ? 1 : max( 1, $neuronet_template_args['columns'] );
	$neuronet_blog_style = array( $neuronet_template_args['type'], $neuronet_columns );
	if ( ! empty( $neuronet_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $neuronet_columns > 1 ) {
	    $neuronet_columns_class = neuronet_get_column_class( 1, $neuronet_columns, ! empty( $neuronet_template_args['columns_tablet']) ? $neuronet_template_args['columns_tablet'] : '', ! empty($neuronet_template_args['columns_mobile']) ? $neuronet_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $neuronet_columns_class ); ?>">
		<?php
	}
}
$neuronet_expanded    = ! neuronet_sidebar_present() && neuronet_get_theme_option( 'expand_content' ) == 'expand';
$neuronet_post_format = get_post_format();
$neuronet_post_format = empty( $neuronet_post_format ) ? 'standard' : str_replace( 'post-format-', '', $neuronet_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $neuronet_post_format ) );
	neuronet_add_blog_animation( $neuronet_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$neuronet_hover      = ! empty( $neuronet_template_args['hover'] ) && ! neuronet_is_inherit( $neuronet_template_args['hover'] )
							? $neuronet_template_args['hover']
							: neuronet_get_theme_option( 'image_hover' );
	$neuronet_components = ! empty( $neuronet_template_args['meta_parts'] )
							? ( is_array( $neuronet_template_args['meta_parts'] )
								? $neuronet_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $neuronet_template_args['meta_parts'] ) )
								)
							: neuronet_array_get_keys_by_value( neuronet_get_theme_option( 'meta_parts' ) );
	neuronet_show_post_featured( apply_filters( 'neuronet_filter_args_featured',
		array(
			'no_links'   => ! empty( $neuronet_template_args['no_links'] ),
			'hover'      => $neuronet_hover,
			'meta_parts' => $neuronet_components,
			'thumb_size' => ! empty( $neuronet_template_args['thumb_size'] )
							? $neuronet_template_args['thumb_size']
							: neuronet_get_thumb_size( strpos( neuronet_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $neuronet_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$neuronet_template_args
	) );

	// Title and post meta
	$neuronet_show_title = get_the_title() != '';
	$neuronet_show_meta  = count( $neuronet_components ) > 0 && ! in_array( $neuronet_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $neuronet_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'neuronet_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'neuronet_action_before_post_title' );
				if ( empty( $neuronet_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'neuronet_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'neuronet_filter_show_blog_excerpt', empty( $neuronet_template_args['hide_excerpt'] ) && neuronet_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'neuronet_filter_show_blog_meta', $neuronet_show_meta, $neuronet_components, 'excerpt' ) ) {
				if ( count( $neuronet_components ) > 0 ) {
					do_action( 'neuronet_action_before_post_meta' );
					neuronet_show_post_meta(
						apply_filters(
							'neuronet_filter_post_meta_args', array(
								'components' => join( ',', $neuronet_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'neuronet_action_after_post_meta' );
				}
			}

			if ( neuronet_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'neuronet_action_before_full_post_content' );
					the_content( '' );
					do_action( 'neuronet_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'neuronet' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'neuronet' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				neuronet_show_post_content( $neuronet_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'neuronet_filter_show_blog_readmore',  ! isset( $neuronet_template_args['more_button'] ) || ! empty( $neuronet_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $neuronet_template_args['no_links'] ) ) {
					do_action( 'neuronet_action_before_post_readmore' );
					if ( neuronet_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						neuronet_show_post_more_link( $neuronet_template_args, '<p>', '</p>' );
					} else {
						neuronet_show_post_comments_link( $neuronet_template_args, '<p>', '</p>' );
					}
					do_action( 'neuronet_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $neuronet_template_args ) ) {
	if ( ! empty( $neuronet_template_args['slider'] ) || $neuronet_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
