<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package NEURONET
 * @since NEURONET 1.0.50
 */

$neuronet_template_args = get_query_var( 'neuronet_template_args' );
if ( is_array( $neuronet_template_args ) ) {
	$neuronet_columns    = empty( $neuronet_template_args['columns'] ) ? 2 : max( 1, $neuronet_template_args['columns'] );
	$neuronet_blog_style = array( $neuronet_template_args['type'], $neuronet_columns );
} else {
	$neuronet_blog_style = explode( '_', neuronet_get_theme_option( 'blog_style' ) );
	$neuronet_columns    = empty( $neuronet_blog_style[1] ) ? 2 : max( 1, $neuronet_blog_style[1] );
}
$neuronet_blog_id       = neuronet_get_custom_blog_id( join( '_', $neuronet_blog_style ) );
$neuronet_blog_style[0] = str_replace( 'blog-custom-', '', $neuronet_blog_style[0] );
$neuronet_expanded      = ! neuronet_sidebar_present() && neuronet_get_theme_option( 'expand_content' ) == 'expand';
$neuronet_components    = ! empty( $neuronet_template_args['meta_parts'] )
							? ( is_array( $neuronet_template_args['meta_parts'] )
								? join( ',', $neuronet_template_args['meta_parts'] )
								: $neuronet_template_args['meta_parts']
								)
							: neuronet_array_get_keys_by_value( neuronet_get_theme_option( 'meta_parts' ) );
$neuronet_post_format   = get_post_format();
$neuronet_post_format   = empty( $neuronet_post_format ) ? 'standard' : str_replace( 'post-format-', '', $neuronet_post_format );

$neuronet_blog_meta     = neuronet_get_custom_layout_meta( $neuronet_blog_id );
$neuronet_custom_style  = ! empty( $neuronet_blog_meta['scripts_required'] ) ? $neuronet_blog_meta['scripts_required'] : 'none';

if ( ! empty( $neuronet_template_args['slider'] ) || $neuronet_columns > 1 || ! neuronet_is_off( $neuronet_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $neuronet_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( neuronet_is_off( $neuronet_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $neuronet_custom_style ) ) . "-1_{$neuronet_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $neuronet_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $neuronet_columns )
					. ' post_layout_' . esc_attr( $neuronet_blog_style[0] )
					. ' post_layout_' . esc_attr( $neuronet_blog_style[0] ) . '_' . esc_attr( $neuronet_columns )
					. ( ! neuronet_is_off( $neuronet_custom_style )
						? ' post_layout_' . esc_attr( $neuronet_custom_style )
							. ' post_layout_' . esc_attr( $neuronet_custom_style ) . '_' . esc_attr( $neuronet_columns )
						: ''
						)
		);
	neuronet_add_blog_animation( $neuronet_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'neuronet_action_show_layout', $neuronet_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $neuronet_template_args['slider'] ) || $neuronet_columns > 1 || ! neuronet_is_off( $neuronet_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
