<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package NEURONET
 * @since NEURONET 1.0
 */

$neuronet_template_args = get_query_var( 'neuronet_template_args' );

if ( is_array( $neuronet_template_args ) ) {
	$neuronet_columns    = empty( $neuronet_template_args['columns'] ) ? 2 : max( 1, $neuronet_template_args['columns'] );
	$neuronet_blog_style = array( $neuronet_template_args['type'], $neuronet_columns );
    $neuronet_columns_class = neuronet_get_column_class( 1, $neuronet_columns, ! empty( $neuronet_template_args['columns_tablet']) ? $neuronet_template_args['columns_tablet'] : '', ! empty($neuronet_template_args['columns_mobile']) ? $neuronet_template_args['columns_mobile'] : '' );
} else {
	$neuronet_blog_style = explode( '_', neuronet_get_theme_option( 'blog_style' ) );
	$neuronet_columns    = empty( $neuronet_blog_style[1] ) ? 2 : max( 1, $neuronet_blog_style[1] );
    $neuronet_columns_class = neuronet_get_column_class( 1, $neuronet_columns );
}
$neuronet_expanded   = ! neuronet_sidebar_present() && neuronet_get_theme_option( 'expand_content' ) == 'expand';

$neuronet_post_format = get_post_format();
$neuronet_post_format = empty( $neuronet_post_format ) ? 'standard' : str_replace( 'post-format-', '', $neuronet_post_format );

?><div class="<?php
	if ( ! empty( $neuronet_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( neuronet_is_blog_style_use_masonry( $neuronet_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $neuronet_columns ) : esc_attr( $neuronet_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $neuronet_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $neuronet_columns )
				. ' post_layout_' . esc_attr( $neuronet_blog_style[0] )
				. ' post_layout_' . esc_attr( $neuronet_blog_style[0] ) . '_' . esc_attr( $neuronet_columns )
	);
	neuronet_add_blog_animation( $neuronet_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$neuronet_hover      = ! empty( $neuronet_template_args['hover'] ) && ! neuronet_is_inherit( $neuronet_template_args['hover'] )
							? $neuronet_template_args['hover']
							: neuronet_get_theme_option( 'image_hover' );

	$neuronet_components = ! empty( $neuronet_template_args['meta_parts'] )
							? ( is_array( $neuronet_template_args['meta_parts'] )
								? $neuronet_template_args['meta_parts']
								: explode( ',', $neuronet_template_args['meta_parts'] )
								)
							: neuronet_array_get_keys_by_value( neuronet_get_theme_option( 'meta_parts' ) );

	neuronet_show_post_featured( apply_filters( 'neuronet_filter_args_featured',
		array(
			'thumb_size' => ! empty( $neuronet_template_args['thumb_size'] )
				? $neuronet_template_args['thumb_size']
				: neuronet_get_thumb_size(
				'classic' == $neuronet_blog_style[0]
						? ( strpos( neuronet_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $neuronet_columns > 2 ? 'big' : 'huge' )
								: ( $neuronet_columns > 2
									? ( $neuronet_expanded ? 'square' : 'square' )
									: ($neuronet_columns > 1 ? 'square' : ( $neuronet_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( neuronet_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $neuronet_columns > 2 ? 'masonry-big' : 'full' )
								: ($neuronet_columns === 1 ? ( $neuronet_expanded ? 'huge' : 'big' ) : ( $neuronet_columns <= 2 && $neuronet_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $neuronet_hover,
			'meta_parts' => $neuronet_components,
			'no_links'   => ! empty( $neuronet_template_args['no_links'] ),
        ),
        'content-classic',
        $neuronet_template_args
    ) );

	// Title and post meta
	$neuronet_show_title = get_the_title() != '';
	$neuronet_show_meta  = count( $neuronet_components ) > 0 && ! in_array( $neuronet_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $neuronet_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'neuronet_filter_show_blog_meta', $neuronet_show_meta, $neuronet_components, 'classic' ) ) {
				if ( count( $neuronet_components ) > 0 ) {
					do_action( 'neuronet_action_before_post_meta' );
					neuronet_show_post_meta(
						apply_filters(
							'neuronet_filter_post_meta_args', array(
							'components' => join( ',', $neuronet_components ),
							'seo'        => false,
							'echo'       => true,
						), $neuronet_blog_style[0], $neuronet_columns
						)
					);
					do_action( 'neuronet_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'neuronet_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'neuronet_action_before_post_title' );
				if ( empty( $neuronet_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'neuronet_action_after_post_title' );
			}

			if( !in_array( $neuronet_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'neuronet_filter_show_blog_readmore', ! $neuronet_show_title || ! empty( $neuronet_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $neuronet_template_args['no_links'] ) ) {
						do_action( 'neuronet_action_before_post_readmore' );
						neuronet_show_post_more_link( $neuronet_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'neuronet_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $neuronet_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('neuronet_filter_show_blog_excerpt', empty($neuronet_template_args['hide_excerpt']) && neuronet_get_theme_option('excerpt_length') > 0, 'classic')) {
			neuronet_show_post_content($neuronet_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $neuronet_template_args['more_button'] )) {
			if ( empty( $neuronet_template_args['no_links'] ) ) {
				do_action( 'neuronet_action_before_post_readmore' );
				neuronet_show_post_more_link( $neuronet_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'neuronet_action_after_post_readmore' );
			}
		}
		$neuronet_content = ob_get_contents();
		ob_end_clean();
		neuronet_show_layout($neuronet_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
