<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package NEURONET
 * @since NEURONET 1.71.0
 */

$neuronet_template_args = get_query_var( 'neuronet_template_args' );

$neuronet_columns       = 1;

$neuronet_expanded      = ! neuronet_sidebar_present() && neuronet_get_theme_option( 'expand_content' ) == 'expand';

$neuronet_post_format   = get_post_format();
$neuronet_post_format   = empty( $neuronet_post_format ) ? 'standard' : str_replace( 'post-format-', '', $neuronet_post_format );

if ( is_array( $neuronet_template_args ) ) {
	$neuronet_columns    = empty( $neuronet_template_args['columns'] ) ? 1 : max( 1, $neuronet_template_args['columns'] );
	$neuronet_blog_style = array( $neuronet_template_args['type'], $neuronet_columns );
	if ( ! empty( $neuronet_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $neuronet_columns > 1 ) {
	    $neuronet_columns_class = neuronet_get_column_class( 1, $neuronet_columns, ! empty( $neuronet_template_args['columns_tablet']) ? $neuronet_template_args['columns_tablet'] : '', ! empty($neuronet_template_args['columns_mobile']) ? $neuronet_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $neuronet_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $neuronet_post_format ) );
	neuronet_add_blog_animation( $neuronet_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$neuronet_hover      = ! empty( $neuronet_template_args['hover'] ) && ! neuronet_is_inherit( $neuronet_template_args['hover'] )
							? $neuronet_template_args['hover']
							: neuronet_get_theme_option( 'image_hover' );
	$neuronet_components = ! empty( $neuronet_template_args['meta_parts'] )
							? ( is_array( $neuronet_template_args['meta_parts'] )
								? $neuronet_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $neuronet_template_args['meta_parts'] ) )
								)
							: neuronet_array_get_keys_by_value( neuronet_get_theme_option( 'meta_parts' ) );
	neuronet_show_post_featured( apply_filters( 'neuronet_filter_args_featured',
		array(
			'no_links'   => ! empty( $neuronet_template_args['no_links'] ),
			'hover'      => $neuronet_hover,
			'meta_parts' => $neuronet_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $neuronet_template_args['thumb_size'] )
								? $neuronet_template_args['thumb_size']
								: neuronet_get_thumb_size( 
								in_array( $neuronet_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( neuronet_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $neuronet_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$neuronet_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$neuronet_show_title = get_the_title() != '';
		$neuronet_show_meta  = count( $neuronet_components ) > 0 && ! in_array( $neuronet_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $neuronet_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'neuronet_filter_show_blog_categories', $neuronet_show_meta && in_array( 'categories', $neuronet_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'neuronet_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						neuronet_show_post_meta( apply_filters(
															'neuronet_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $neuronet_hover, 1
															)
											);
						?>
					</div>
					<?php
					$neuronet_components = neuronet_array_delete_by_value( $neuronet_components, 'categories' );
					do_action( 'neuronet_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'neuronet_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'neuronet_action_before_post_title' );
					if ( empty( $neuronet_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'neuronet_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $neuronet_template_args['excerpt_length'] ) && ! in_array( $neuronet_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$neuronet_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'neuronet_filter_show_blog_excerpt', empty( $neuronet_template_args['hide_excerpt'] ) && neuronet_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				neuronet_show_post_content( $neuronet_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'neuronet_filter_show_blog_meta', $neuronet_show_meta, $neuronet_components, 'band' ) ) {
			if ( count( $neuronet_components ) > 0 ) {
				do_action( 'neuronet_action_before_post_meta' );
				neuronet_show_post_meta(
					apply_filters(
						'neuronet_filter_post_meta_args', array(
							'components' => join( ',', $neuronet_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'neuronet_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'neuronet_filter_show_blog_readmore', ! $neuronet_show_title || ! empty( $neuronet_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $neuronet_template_args['no_links'] ) ) {
				do_action( 'neuronet_action_before_post_readmore' );
				neuronet_show_post_more_link( $neuronet_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'neuronet_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $neuronet_template_args ) ) {
	if ( ! empty( $neuronet_template_args['slider'] ) || $neuronet_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
