<?php
/**
 * The template to display the user's avatar, bio and socials on the Author page
 *
 * @package NEURONET
 * @since NEURONET 1.71.0
 */
?>

<div class="author_page author vcard" itemprop="author" itemscope="itemscope" itemtype="<?php echo esc_attr( neuronet_get_protocol( true ) ); ?>//schema.org/Person">

	<div class="author_avatar" itemprop="image">
		<?php
		$neuronet_mult = neuronet_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120 * $neuronet_mult );
		?>
	</div><!-- .author_avatar -->

	<h4 class="author_title" itemprop="name"><span class="fn"><?php the_author(); ?></span></h4>

	<?php
	$neuronet_author_description = get_the_author_meta( 'description' );
	if ( ! empty( $neuronet_author_description ) ) {
		?>
		<div class="author_bio" itemprop="description"><?php echo wp_kses( wpautop( $neuronet_author_description ), 'neuronet_kses_content' ); ?></div>
		<?php
	}
	?>

	<div class="author_details">
		<span class="author_posts_total">
			<?php
			$neuronet_posts_total = count_user_posts( get_the_author_meta('ID'), 'post' );
			if ( $neuronet_posts_total > 0 ) {
				// Translators: Add the author's posts number to the message
				echo wp_kses( sprintf( _n( '%s article published', '%s articles published', $neuronet_posts_total, 'neuronet' ),
										'<span class="author_posts_total_value">' . number_format_i18n( $neuronet_posts_total ) . '</span>'
								 		),
							'neuronet_kses_content'
							);
			} else {
				esc_html_e( 'No posts published.', 'neuronet' );
			}
			?>
		</span><?php
			ob_start();
			do_action( 'neuronet_action_user_meta', 'author-page' );
			$neuronet_socials = ob_get_contents();
			ob_end_clean();
			neuronet_show_layout( $neuronet_socials,
				'<span class="author_socials"><span class="author_socials_caption">' . esc_html__( 'Follow:', 'neuronet' ) . '</span>',
				'</span>'
			);
		?>
	</div><!-- .author_details -->

</div><!-- .author_page -->
