<?php
/**
 * The template to display Admin notices
 *
 * @package NEURONET
 * @since NEURONET 1.0.1
 */

$neuronet_theme_slug = get_option( 'template' );
$neuronet_theme_obj  = wp_get_theme( $neuronet_theme_slug );

?>
<div class="neuronet_admin_notice neuronet_rate_notice notice notice-info is-dismissible" data-notice="rate">
	<?php
	// Theme image
	$neuronet_theme_img = neuronet_get_file_url( 'screenshot.jpg' );
	if ( '' != $neuronet_theme_img ) {
		?>
		<div class="neuronet_notice_image"><img src="<?php echo esc_url( $neuronet_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'neuronet' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="neuronet_notice_title"><a href="<?php echo esc_url( neuronet_storage_get( 'theme_rate_url' ) ); ?>" target="_blank">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Rate our theme "%s", please', 'neuronet' ),
				$neuronet_theme_obj->get( 'Name' ) . ( NEURONET_THEME_FREE ? ' ' . __( 'Free', 'neuronet' ) : '' )
			)
		);
		?>
	</a></h3>
	<?php

	// Description
	?>
	<div class="neuronet_notice_text">
		<p><?php echo wp_kses_data( __( "We are glad you chose our WP theme for your website. You've done well customizing your website and we hope that you've enjoyed working with our theme.", 'neuronet' ) ); ?></p>
		<p><?php echo wp_kses_data( __( "It would be just awesome if you spend just a minute of your time to rate our theme or the customer service you've received from us.", 'neuronet' ) ); ?></p>
		<p class="neuronet_notice_text_info"><?php echo wp_kses_data( __( '* We love receiving your reviews! Every time you leave a review, our CEO Henry Rise gives $5 to homeless dog shelter! Save the planet with us!', 'neuronet' ) ); ?></p>
	</div>
	<?php

	// Buttons
	?>
	<div class="neuronet_notice_buttons">
		<?php
		// Link to the theme download page
		?>
		<a href="<?php echo esc_url( neuronet_storage_get( 'theme_rate_url' ) ); ?>" class="button button-primary" target="_blank"><i class="dashicons dashicons-star-filled"></i> 
			<?php
			// Translators: Add theme name
			echo esc_html( sprintf( __( 'Rate theme %s', 'neuronet' ), $neuronet_theme_obj->name ) );
			?>
		</a>
		<?php
		// Link to the theme support
		?>
		<a href="<?php echo esc_url( neuronet_storage_get( 'theme_support_url' ) ); ?>" class="button" target="_blank"><i class="dashicons dashicons-sos"></i> 
			<?php
			esc_html_e( 'Support', 'neuronet' );
			?>
		</a>
		<?php
		// Link to the theme documentation
		?>
		<a href="<?php echo esc_url( neuronet_storage_get( 'theme_doc_url' ) ); ?>" class="button" target="_blank"><i class="dashicons dashicons-book"></i> 
			<?php
			esc_html_e( 'Documentation', 'neuronet' );
			?>
		</a>
	</div>
</div>
