<?php
/**
 * The template to display Admin notices
 *
 * @package NEURONET
 * @since NEURONET 1.0.1
 */

$neuronet_theme_slug = get_option( 'template' );
$neuronet_theme_obj  = wp_get_theme( $neuronet_theme_slug );
?>
<div class="neuronet_admin_notice neuronet_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$neuronet_theme_img = neuronet_get_file_url( 'screenshot.jpg' );
	if ( '' != $neuronet_theme_img ) {
		?>
		<div class="neuronet_notice_image"><img src="<?php echo esc_url( $neuronet_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'neuronet' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="neuronet_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'neuronet' ),
				$neuronet_theme_obj->get( 'Name' ) . ( NEURONET_THEME_FREE ? ' ' . __( 'Free', 'neuronet' ) : '' ),
				$neuronet_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="neuronet_notice_text">
		<p class="neuronet_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $neuronet_theme_obj->description ) );
			?>
		</p>
		<p class="neuronet_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'neuronet' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="neuronet_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=neuronet_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'neuronet' );
			?>
		</a>
	</div>
</div>
