<?php
/**
 * Required plugins
 *
 * @package NEURONET
 * @since NEURONET 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
$neuronet_theme_required_plugins_groups = array(
	'core'          => esc_html__( 'Core', 'neuronet' ),
	'page_builders' => esc_html__( 'Page Builders', 'neuronet' ),
	'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'neuronet' ),
	'socials'       => esc_html__( 'Socials and Communities', 'neuronet' ),
	'events'        => esc_html__( 'Events and Appointments', 'neuronet' ),
	'content'       => esc_html__( 'Content', 'neuronet' ),
	'other'         => esc_html__( 'Other', 'neuronet' ),
);
$neuronet_theme_required_plugins        = array(
	'trx_addons'                 => array(
		'title'       => esc_html__( 'ThemeREX Addons', 'neuronet' ),
		'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'neuronet' ),
		'required'    => true,
		'logo'        => 'trx_addons.png',
		'group'       => $neuronet_theme_required_plugins_groups['core'],
	),
	'elementor'                  => array(
		'title'       => esc_html__( 'Elementor', 'neuronet' ),
		'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'neuronet' ),
		'required'    => false,
		'logo'        => 'elementor.png',
		'group'       => $neuronet_theme_required_plugins_groups['page_builders'],
	),
	'gutenberg'                  => array(
		'title'       => esc_html__( 'Gutenberg', 'neuronet' ),
		'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'neuronet' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'gutenberg.png',
		'group'       => $neuronet_theme_required_plugins_groups['page_builders'],
	),
	'js_composer'                => array(
		'title'       => esc_html__( 'WPBakery PageBuilder', 'neuronet' ),
		'description' => esc_html__( "Popular PageBuilder which allows you to create excellent pages", 'neuronet' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'js_composer.jpg',
		'group'       => $neuronet_theme_required_plugins_groups['page_builders'],
	),
	'woocommerce'                => array(
		'title'       => esc_html__( 'WooCommerce', 'neuronet' ),
		'description' => esc_html__( "Connect the store to your website and start selling now", 'neuronet' ),
		'required'    => false,
		'logo'        => 'woocommerce.png',
		'group'       => $neuronet_theme_required_plugins_groups['ecommerce'],
	),
	'elegro-payment'             => array(
		'title'       => esc_html__( 'Elegro Crypto Payment', 'neuronet' ),
		'description' => esc_html__( "Extends WooCommerce Payment Gateways with an elegro Crypto Payment", 'neuronet' ),
		'required'    => false,
		'logo'        => 'elegro-payment.png',
		'group'       => $neuronet_theme_required_plugins_groups['ecommerce'],
	),
	'instagram-feed'             => array(
		'title'       => esc_html__( 'Instagram Feed', 'neuronet' ),
		'description' => esc_html__( "Displays the latest photos from your profile on Instagram", 'neuronet' ),
		'required'    => false,
		'logo'        => 'instagram-feed.png',
		'group'       => $neuronet_theme_required_plugins_groups['socials'],
	),
	'mailchimp-for-wp'           => array(
		'title'       => esc_html__( 'MailChimp for WP', 'neuronet' ),
		'description' => esc_html__( "Allows visitors to subscribe to newsletters", 'neuronet' ),
		'required'    => false,
		'logo'        => 'mailchimp-for-wp.png',
		'group'       => $neuronet_theme_required_plugins_groups['socials'],
	),
	'booked'                     => array(
		'title'       => esc_html__( 'Booked Appointments', 'neuronet' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'booked.png',
		'group'       => $neuronet_theme_required_plugins_groups['events'],
	),
	'the-events-calendar'        => array(
		'title'       => esc_html__( 'The Events Calendar', 'neuronet' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'the-events-calendar.png',
		'group'       => $neuronet_theme_required_plugins_groups['events'],
	),
	'contact-form-7'             => array(
		'title'       => esc_html__( 'Contact Form 7', 'neuronet' ),
		'description' => esc_html__( "CF7 allows you to create an unlimited number of contact forms", 'neuronet' ),
		'required'    => false,
		'logo'        => 'contact-form-7.png',
		'group'       => $neuronet_theme_required_plugins_groups['content'],
	),

	'latepoint'                  => array(
		'title'       => esc_html__( 'LatePoint', 'neuronet' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => neuronet_get_file_url( 'plugins/latepoint/latepoint.png' ),
		'group'       => $neuronet_theme_required_plugins_groups['events'],
	),
	'advanced-popups'                  => array(
		'title'       => esc_html__( 'Advanced Popups', 'neuronet' ),
		'description' => '',
		'required'    => false,
		'logo'        => neuronet_get_file_url( 'plugins/advanced-popups/advanced-popups.jpg' ),
		'group'       => $neuronet_theme_required_plugins_groups['content'],
	),
	'devvn-image-hotspot'                  => array(
		'title'       => esc_html__( 'Image Hotspot by DevVN', 'neuronet' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => neuronet_get_file_url( 'plugins/devvn-image-hotspot/devvn-image-hotspot.png' ),
		'group'       => $neuronet_theme_required_plugins_groups['content'],
	),
	'ti-woocommerce-wishlist'                  => array(
		'title'       => esc_html__( 'TI WooCommerce Wishlist', 'neuronet' ),
		'description' => '',
		'required'    => false,
		'logo'        => neuronet_get_file_url( 'plugins/ti-woocommerce-wishlist/ti-woocommerce-wishlist.png' ),
		'group'       => $neuronet_theme_required_plugins_groups['ecommerce'],
	),
	'woo-smart-quick-view'                  => array(
		'title'       => esc_html__( 'WPC Smart Quick View for WooCommerce', 'neuronet' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => neuronet_get_file_url( 'plugins/woo-smart-quick-view/woo-smart-quick-view.png' ),
		'group'       => $neuronet_theme_required_plugins_groups['ecommerce'],
	),
	'twenty20'                  => array(
		'title'       => esc_html__( 'Twenty20 Image Before-After', 'neuronet' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => neuronet_get_file_url( 'plugins/twenty20/twenty20.png' ),
		'group'       => $neuronet_theme_required_plugins_groups['content'],
	),
	'essential-grid'             => array(
		'title'       => esc_html__( 'Essential Grid', 'neuronet' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'essential-grid.png',
		'group'       => $neuronet_theme_required_plugins_groups['content'],
	),
	'revslider'                  => array(
		'title'       => esc_html__( 'Revolution Slider', 'neuronet' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'revslider.png',
		'group'       => $neuronet_theme_required_plugins_groups['content'],
	),
	'sitepress-multilingual-cms' => array(
		'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'neuronet' ),
		'description' => esc_html__( "Allows you to make your website multilingual", 'neuronet' ),
		'required'    => false,
		'install'     => false,      // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'sitepress-multilingual-cms.png',
		'group'       => $neuronet_theme_required_plugins_groups['content'],
	),
	'wp-gdpr-compliance'         => array(
		'title'       => esc_html__( 'Cookie Information', 'neuronet' ),
		'description' => esc_html__( "Allow visitors to decide for themselves what personal data they want to store on your site", 'neuronet' ),
		'required'    => false,
		'logo'        => 'wp-gdpr-compliance.png',
		'group'       => $neuronet_theme_required_plugins_groups['other'],
	),
	'trx_updater'                => array(
		'title'       => esc_html__( 'ThemeREX Updater', 'neuronet' ),
		'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'neuronet' ),
		'required'    => false,
		'logo'        => 'trx_updater.png',
		'group'       => $neuronet_theme_required_plugins_groups['other'],
	),
);

if ( NEURONET_THEME_FREE ) {
	unset( $neuronet_theme_required_plugins['js_composer'] );
	unset( $neuronet_theme_required_plugins['booked'] );
	unset( $neuronet_theme_required_plugins['the-events-calendar'] );
	unset( $neuronet_theme_required_plugins['calculated-fields-form'] );
	unset( $neuronet_theme_required_plugins['essential-grid'] );
	unset( $neuronet_theme_required_plugins['revslider'] );
	unset( $neuronet_theme_required_plugins['sitepress-multilingual-cms'] );
	unset( $neuronet_theme_required_plugins['trx_updater'] );
	unset( $neuronet_theme_required_plugins['trx_popup'] );
}

// Add plugins list to the global storage
neuronet_storage_set( 'required_plugins', $neuronet_theme_required_plugins );
