<?php
/**
 * The template to display single post
 *
 * @package NEURONET
 * @since NEURONET 1.0
 */

// Full post loading
$full_post_loading          = neuronet_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = neuronet_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = neuronet_get_theme_option( 'posts_navigation_scroll_which_block' );

// Position of the related posts
$neuronet_related_position   = neuronet_get_theme_option( 'related_position' );

// Type of the prev/next post navigation
$neuronet_posts_navigation   = neuronet_get_theme_option( 'posts_navigation' );
$neuronet_prev_post          = false;
$neuronet_prev_post_same_cat = neuronet_get_theme_option( 'posts_navigation_scroll_same_cat' );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( neuronet_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	neuronet_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'neuronet_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $neuronet_posts_navigation ) {
		$neuronet_prev_post = get_previous_post( $neuronet_prev_post_same_cat );  // Get post from same category
		if ( ! $neuronet_prev_post && $neuronet_prev_post_same_cat ) {
			$neuronet_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $neuronet_prev_post ) {
			$neuronet_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $neuronet_prev_post ) ) {
		neuronet_sc_layouts_showed( 'featured', false );
		neuronet_sc_layouts_showed( 'title', false );
		neuronet_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $neuronet_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'neuronet_filter_get_template_part', 'templates/content', 'single-' . neuronet_get_theme_option( 'single_style' ) ), 'single-' . neuronet_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $neuronet_related_position, 'inside' ) === 0 ) {
		$neuronet_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'neuronet_action_related_posts' );
		$neuronet_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $neuronet_related_content ) ) {
			$neuronet_related_position_inside = max( 0, min( 9, neuronet_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $neuronet_related_position_inside ) {
				$neuronet_related_position_inside = mt_rand( 1, 9 );
			}

			$neuronet_p_number         = 0;
			$neuronet_related_inserted = false;
			$neuronet_in_block         = false;
			$neuronet_content_start    = strpos( $neuronet_content, '<div class="post_content' );
			$neuronet_content_end      = strrpos( $neuronet_content, '</div>' );

			for ( $i = max( 0, $neuronet_content_start ); $i < min( strlen( $neuronet_content ) - 3, $neuronet_content_end ); $i++ ) {
				if ( $neuronet_content[ $i ] != '<' ) {
					continue;
				}
				if ( $neuronet_in_block ) {
					if ( strtolower( substr( $neuronet_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$neuronet_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $neuronet_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $neuronet_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$neuronet_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $neuronet_content[ $i + 1 ] && in_array( $neuronet_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$neuronet_p_number++;
					if ( $neuronet_related_position_inside == $neuronet_p_number ) {
						$neuronet_related_inserted = true;
						$neuronet_content = ( $i > 0 ? substr( $neuronet_content, 0, $i ) : '' )
											. $neuronet_related_content
											. substr( $neuronet_content, $i );
					}
				}
			}
			if ( ! $neuronet_related_inserted ) {
				if ( $neuronet_content_end > 0 ) {
					$neuronet_content = substr( $neuronet_content, 0, $neuronet_content_end ) . $neuronet_related_content . substr( $neuronet_content, $neuronet_content_end );
				} else {
					$neuronet_content .= $neuronet_related_content;
				}
			}
		}

		neuronet_show_layout( $neuronet_content );
	}

	// Comments
	do_action( 'neuronet_action_before_comments' );
	comments_template();
	do_action( 'neuronet_action_after_comments' );

	// Related posts
	if ( 'below_content' == $neuronet_related_position
		&& ( 'scroll' != $neuronet_posts_navigation || neuronet_get_theme_option( 'posts_navigation_scroll_hide_related' ) == 0 )
		&& ( ! $full_post_loading || neuronet_get_theme_option( 'open_full_post_hide_related' ) == 0 )
	) {
		do_action( 'neuronet_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $neuronet_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $neuronet_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $neuronet_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $neuronet_prev_post ) ); ?>"
			<?php do_action( 'neuronet_action_nav_links_single_scroll_data', $neuronet_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
