<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package NEURONET
 * @since NEURONET 1.0
 */

if ( neuronet_sidebar_present() ) {
	
	$neuronet_sidebar_type = neuronet_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $neuronet_sidebar_type && ! neuronet_is_layouts_available() ) {
		$neuronet_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $neuronet_sidebar_type ) {
		// Default sidebar with widgets
		$neuronet_sidebar_name = neuronet_get_theme_option( 'sidebar_widgets' );
		neuronet_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $neuronet_sidebar_name ) ) {
			dynamic_sidebar( $neuronet_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$neuronet_sidebar_id = neuronet_get_custom_sidebar_id();
		do_action( 'neuronet_action_show_layout', $neuronet_sidebar_id );
	}
	$neuronet_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $neuronet_out ) ) {
		$neuronet_sidebar_position    = neuronet_get_theme_option( 'sidebar_position' );
		$neuronet_sidebar_position_ss = neuronet_get_theme_option( 'sidebar_position_ss' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $neuronet_sidebar_position );
			echo ' sidebar_' . esc_attr( $neuronet_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $neuronet_sidebar_type );

			$neuronet_sidebar_scheme = apply_filters( 'neuronet_filter_sidebar_scheme', neuronet_get_theme_option( 'sidebar_scheme' ) );
			if ( ! empty( $neuronet_sidebar_scheme ) && ! neuronet_is_inherit( $neuronet_sidebar_scheme ) && 'custom' != $neuronet_sidebar_type ) {
				echo ' scheme_' . esc_attr( $neuronet_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="neuronet_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'neuronet_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $neuronet_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$neuronet_title = apply_filters( 'neuronet_filter_sidebar_control_title', 'float' == $neuronet_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'neuronet' ) : '' );
				$neuronet_text  = apply_filters( 'neuronet_filter_sidebar_control_text', 'above' == $neuronet_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'neuronet' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $neuronet_title ); ?>"><?php echo esc_html( $neuronet_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'neuronet_action_before_sidebar', 'sidebar' );
				neuronet_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $neuronet_out ) );
				do_action( 'neuronet_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'neuronet_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
