<?php
/* Mail Chimp support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'neuronet_mailchimp_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'neuronet_mailchimp_theme_setup9', 9 );
	function neuronet_mailchimp_theme_setup9() {
		if ( neuronet_exists_mailchimp() ) {
			add_action( 'wp_enqueue_scripts', 'neuronet_mailchimp_frontend_scripts', 1100 );
			add_action( 'trx_addons_action_load_scripts_front_mailchimp', 'neuronet_mailchimp_frontend_scripts', 10, 1 );
			add_filter( 'neuronet_filter_merge_styles', 'neuronet_mailchimp_merge_styles' );
		}
		if ( is_admin() ) {
			add_filter( 'neuronet_filter_tgmpa_required_plugins', 'neuronet_mailchimp_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'neuronet_mailchimp_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('neuronet_filter_tgmpa_required_plugins',	'neuronet_mailchimp_tgmpa_required_plugins');
	function neuronet_mailchimp_tgmpa_required_plugins( $list = array() ) {
		if ( neuronet_storage_isset( 'required_plugins', 'mailchimp-for-wp' ) && neuronet_storage_get_array( 'required_plugins', 'mailchimp-for-wp', 'install' ) !== false ) {
			$list[] = array(
				'name'     => neuronet_storage_get_array( 'required_plugins', 'mailchimp-for-wp', 'title' ),
				'slug'     => 'mailchimp-for-wp',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'neuronet_exists_mailchimp' ) ) {
	function neuronet_exists_mailchimp() {
		return function_exists( '__mc4wp_load_plugin' ) || defined( 'MC4WP_VERSION' );
	}
}



// Custom styles and scripts
//------------------------------------------------------------------------

// Enqueue styles for frontend
if ( ! function_exists( 'neuronet_mailchimp_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'neuronet_mailchimp_frontend_scripts', 1100 );
	//Handler of the add_action( 'trx_addons_action_load_scripts_front_mailchimp', 'neuronet_mailchimp_frontend_scripts', 10, 1 );
	function neuronet_mailchimp_frontend_scripts( $force = false ) {
		static $loaded = false;
		if ( ! $loaded && (
			current_action() == 'wp_enqueue_scripts' && neuronet_need_frontend_scripts( 'mailchimp' )
			||
			current_action() != 'wp_enqueue_scripts' && $force === true
			)
		) {
			$loaded = true;
			$neuronet_url = neuronet_get_file_url( 'plugins/mailchimp-for-wp/mailchimp-for-wp.css' );
			if ( '' != $neuronet_url ) {
				wp_enqueue_style( 'neuronet-mailchimp-for-wp', $neuronet_url, array(), null );
			}
		}
	}
}

// Merge custom styles
if ( ! function_exists( 'neuronet_mailchimp_merge_styles' ) ) {
	//Handler of the add_filter( 'neuronet_filter_merge_styles', 'neuronet_mailchimp_merge_styles');
	function neuronet_mailchimp_merge_styles( $list ) {
		$list[ 'plugins/mailchimp-for-wp/mailchimp-for-wp.css' ] = false;
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( neuronet_exists_mailchimp() ) {
	$neuronet_fdir = neuronet_get_file_dir( 'plugins/mailchimp-for-wp/mailchimp-for-wp-style.php' );
	if ( ! empty( $neuronet_fdir ) ) {
		require_once $neuronet_fdir;
	}
}

