<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package NEURONET
 * @since NEURONET 1.0
 */

$neuronet_template = apply_filters( 'neuronet_filter_get_template_part', neuronet_blog_archive_get_template() );

if ( ! empty( $neuronet_template ) && 'index' != $neuronet_template ) {

	get_template_part( $neuronet_template );

} else {

	neuronet_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$neuronet_stickies   = is_home()
								|| ( in_array( neuronet_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) neuronet_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$neuronet_post_type  = neuronet_get_theme_option( 'post_type' );
		$neuronet_args       = array(
								'blog_style'     => neuronet_get_theme_option( 'blog_style' ),
								'post_type'      => $neuronet_post_type,
								'taxonomy'       => neuronet_get_post_type_taxonomy( $neuronet_post_type ),
								'parent_cat'     => neuronet_get_theme_option( 'parent_cat' ),
								'posts_per_page' => neuronet_get_theme_option( 'posts_per_page' ),
								'sticky'         => neuronet_get_theme_option( 'sticky_style' ) == 'columns'
															&& is_array( $neuronet_stickies )
															&& count( $neuronet_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		neuronet_blog_archive_start();

		do_action( 'neuronet_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'neuronet_action_before_page_author' );
			get_template_part( apply_filters( 'neuronet_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'neuronet_action_after_page_author' );
		}

		if ( neuronet_get_theme_option( 'show_filters' ) ) {
			do_action( 'neuronet_action_before_page_filters' );
			neuronet_show_filters( $neuronet_args );
			do_action( 'neuronet_action_after_page_filters' );
		} else {
			do_action( 'neuronet_action_before_page_posts' );
			neuronet_show_posts( array_merge( $neuronet_args, array( 'cat' => $neuronet_args['parent_cat'] ) ) );
			do_action( 'neuronet_action_after_page_posts' );
		}

		do_action( 'neuronet_action_blog_archive_end' );

		neuronet_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'neuronet_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'neuronet_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
