<?php
/**
 * The Header: Logo and main menu
 *
 * @package NEURONET
 * @since NEURONET 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( neuronet_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'neuronet_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'neuronet_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('neuronet_action_body_wrap_attributes'); ?>>

		<?php do_action( 'neuronet_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'neuronet_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('neuronet_action_page_wrap_attributes'); ?>>

			<?php do_action( 'neuronet_action_page_wrap_start' ); ?>

			<?php
			$neuronet_full_post_loading = ( neuronet_is_singular( 'post' ) || neuronet_is_singular( 'attachment' ) ) && neuronet_get_value_gp( 'action' ) == 'full_post_loading';
			$neuronet_prev_post_loading = ( neuronet_is_singular( 'post' ) || neuronet_is_singular( 'attachment' ) ) && neuronet_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $neuronet_full_post_loading && ! $neuronet_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="neuronet_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'neuronet_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'neuronet' ); ?></a>
				<?php if ( neuronet_sidebar_present() ) { ?>
				<a class="neuronet_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'neuronet_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'neuronet' ); ?></a>
				<?php } ?>
				<a class="neuronet_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'neuronet_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'neuronet' ); ?></a>

				<?php
				do_action( 'neuronet_action_before_header' );

				// Header
				$neuronet_header_type = neuronet_get_theme_option( 'header_type' );
				if ( 'custom' == $neuronet_header_type && ! neuronet_is_layouts_available() ) {
					$neuronet_header_type = 'default';
				}
				get_template_part( apply_filters( 'neuronet_filter_get_template_part', "templates/header-" . sanitize_file_name( $neuronet_header_type ) ) );

				// Side menu
				if ( in_array( neuronet_get_theme_option( 'menu_side' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'neuronet_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				get_template_part( apply_filters( 'neuronet_filter_get_template_part', 'templates/header-navi-mobile' ) );

				do_action( 'neuronet_action_after_header' );

			}
			?>

			<?php do_action( 'neuronet_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( neuronet_is_off( neuronet_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $neuronet_header_type ) ) {
						$neuronet_header_type = neuronet_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $neuronet_header_type && neuronet_is_layouts_available() ) {
						$neuronet_header_id = neuronet_get_custom_header_id();
						if ( $neuronet_header_id > 0 ) {
							$neuronet_header_meta = neuronet_get_custom_layout_meta( $neuronet_header_id );
							if ( ! empty( $neuronet_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$neuronet_footer_type = neuronet_get_theme_option( 'footer_type' );
					if ( 'custom' == $neuronet_footer_type && neuronet_is_layouts_available() ) {
						$neuronet_footer_id = neuronet_get_custom_footer_id();
						if ( $neuronet_footer_id ) {
							$neuronet_footer_meta = neuronet_get_custom_layout_meta( $neuronet_footer_id );
							if ( ! empty( $neuronet_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'neuronet_action_page_content_wrap_class', $neuronet_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'neuronet_filter_is_prev_post_loading', $neuronet_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( neuronet_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'neuronet_action_page_content_wrap_data', $neuronet_prev_post_loading );
			?>>
				<?php
				do_action( 'neuronet_action_page_content_wrap', $neuronet_full_post_loading || $neuronet_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'neuronet_filter_single_post_header', neuronet_is_singular( 'post' ) || neuronet_is_singular( 'attachment' ) ) ) {
					if ( $neuronet_prev_post_loading ) {
						if ( neuronet_get_theme_option( 'posts_navigation_scroll_which_block' ) != 'article' ) {
							do_action( 'neuronet_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$neuronet_path = apply_filters( 'neuronet_filter_get_template_part', 'templates/single-styles/' . neuronet_get_theme_option( 'single_style' ) );
					if ( neuronet_get_file_dir( $neuronet_path . '.php' ) != '' ) {
						get_template_part( $neuronet_path );
					}
				}

				// Widgets area above page
				$neuronet_body_style   = neuronet_get_theme_option( 'body_style' );
				$neuronet_widgets_name = neuronet_get_theme_option( 'widgets_above_page' );
				$neuronet_show_widgets = ! neuronet_is_off( $neuronet_widgets_name ) && is_active_sidebar( $neuronet_widgets_name );
				if ( $neuronet_show_widgets ) {
					if ( 'fullscreen' != $neuronet_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					neuronet_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $neuronet_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'neuronet_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $neuronet_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'neuronet_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'neuronet_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="neuronet_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( neuronet_is_singular( 'post' ) || neuronet_is_singular( 'attachment' ) )
							&& $neuronet_prev_post_loading 
							&& neuronet_get_theme_option( 'posts_navigation_scroll_which_block' ) == 'article'
						) {
							do_action( 'neuronet_action_between_posts' );
						}

						// Widgets area above content
						neuronet_create_widgets_area( 'widgets_above_content' );

						do_action( 'neuronet_action_page_content_start_text' );
