<?php
$neuronet_woocommerce_sc = neuronet_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $neuronet_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$neuronet_scheme = neuronet_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $neuronet_scheme ) && ! neuronet_is_inherit( $neuronet_scheme ) ) {
			echo ' scheme_' . esc_attr( $neuronet_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( neuronet_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( neuronet_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$neuronet_css      = '';
			$neuronet_bg_image = neuronet_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $neuronet_bg_image ) ) {
				$neuronet_css .= 'background-image: url(' . esc_url( neuronet_get_attachment_url( $neuronet_bg_image ) ) . ');';
			}
			if ( ! empty( $neuronet_css ) ) {
				echo ' style="' . esc_attr( $neuronet_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$neuronet_anchor_icon = neuronet_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$neuronet_anchor_text = neuronet_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $neuronet_anchor_icon ) || ! empty( $neuronet_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $neuronet_anchor_icon ) ? ' icon="' . esc_attr( $neuronet_anchor_icon ) . '"' : '' )
											. ( ! empty( $neuronet_anchor_text ) ? ' title="' . esc_attr( $neuronet_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( neuronet_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' neuronet-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$neuronet_css      = '';
				$neuronet_bg_mask  = neuronet_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$neuronet_bg_color_type = neuronet_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $neuronet_bg_color_type ) {
					$neuronet_bg_color = neuronet_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $neuronet_bg_color_type ) {
					$neuronet_bg_color = neuronet_get_scheme_color( 'bg_color', $neuronet_scheme );
				} else {
					$neuronet_bg_color = '';
				}
				if ( ! empty( $neuronet_bg_color ) && $neuronet_bg_mask > 0 ) {
					$neuronet_css .= 'background-color: ' . esc_attr(
						1 == $neuronet_bg_mask ? $neuronet_bg_color : neuronet_hex2rgba( $neuronet_bg_color, $neuronet_bg_mask )
					) . ';';
				}
				if ( ! empty( $neuronet_css ) ) {
					echo ' style="' . esc_attr( $neuronet_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$neuronet_caption     = neuronet_get_theme_option( 'front_page_woocommerce_caption' );
				$neuronet_description = neuronet_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $neuronet_caption ) || ! empty( $neuronet_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $neuronet_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $neuronet_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $neuronet_caption, 'neuronet_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $neuronet_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $neuronet_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $neuronet_description ), 'neuronet_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $neuronet_woocommerce_sc ) {
						$neuronet_woocommerce_sc_ids      = neuronet_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$neuronet_woocommerce_sc_per_page = count( explode( ',', $neuronet_woocommerce_sc_ids ) );
					} else {
						$neuronet_woocommerce_sc_per_page = max( 1, (int) neuronet_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$neuronet_woocommerce_sc_columns = max( 1, min( $neuronet_woocommerce_sc_per_page, (int) neuronet_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$neuronet_woocommerce_sc}"
										. ( 'products' == $neuronet_woocommerce_sc
												? ' ids="' . esc_attr( $neuronet_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $neuronet_woocommerce_sc
												? ' category="' . esc_attr( neuronet_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $neuronet_woocommerce_sc
												? ' orderby="' . esc_attr( neuronet_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( neuronet_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $neuronet_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $neuronet_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
