<?php
$neuronet_slider_sc = neuronet_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $neuronet_slider_sc ) && strpos( $neuronet_slider_sc, '[' ) !== false && strpos( $neuronet_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( neuronet_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$neuronet_anchor_icon = neuronet_get_theme_option( 'front_page_title_anchor_icon' );
		$neuronet_anchor_text = neuronet_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $neuronet_anchor_icon ) || ! empty( $neuronet_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $neuronet_anchor_icon ) ? ' icon="' . esc_attr( $neuronet_anchor_icon ) . '"' : '' )
									. ( ! empty( $neuronet_anchor_text ) ? ' title="' . esc_attr( $neuronet_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $neuronet_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$neuronet_scheme = neuronet_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $neuronet_scheme ) && ! neuronet_is_inherit( $neuronet_scheme ) ) {
			echo ' scheme_' . esc_attr( $neuronet_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( neuronet_get_theme_option( 'front_page_title_paddings' ) );
		if ( neuronet_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$neuronet_css      = '';
		$neuronet_bg_image = neuronet_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $neuronet_bg_image ) ) {
			$neuronet_css .= 'background-image: url(' . esc_url( neuronet_get_attachment_url( $neuronet_bg_image ) ) . ');';
		}
		if ( ! empty( $neuronet_css ) ) {
			echo ' style="' . esc_attr( $neuronet_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$neuronet_anchor_icon = neuronet_get_theme_option( 'front_page_title_anchor_icon' );
		$neuronet_anchor_text = neuronet_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $neuronet_anchor_icon ) || ! empty( $neuronet_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $neuronet_anchor_icon ) ? ' icon="' . esc_attr( $neuronet_anchor_icon ) . '"' : '' )
									. ( ! empty( $neuronet_anchor_text ) ? ' title="' . esc_attr( $neuronet_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( neuronet_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' neuronet-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$neuronet_css      = '';
			$neuronet_bg_mask  = neuronet_get_theme_option( 'front_page_title_bg_mask' );
			$neuronet_bg_color_type = neuronet_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $neuronet_bg_color_type ) {
				$neuronet_bg_color = neuronet_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $neuronet_bg_color_type ) {
				$neuronet_bg_color = neuronet_get_scheme_color( 'bg_color', $neuronet_scheme );
			} else {
				$neuronet_bg_color = '';
			}
			if ( ! empty( $neuronet_bg_color ) && $neuronet_bg_mask > 0 ) {
				$neuronet_css .= 'background-color: ' . esc_attr(
					1 == $neuronet_bg_mask ? $neuronet_bg_color : neuronet_hex2rgba( $neuronet_bg_color, $neuronet_bg_mask )
				) . ';';
			}
			if ( ! empty( $neuronet_css ) ) {
				echo ' style="' . esc_attr( $neuronet_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$neuronet_caption = neuronet_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $neuronet_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $neuronet_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $neuronet_caption, 'neuronet_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$neuronet_description = neuronet_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $neuronet_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $neuronet_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $neuronet_description ), 'neuronet_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( neuronet_get_theme_option( 'front_page_title_button1_link' ) != '' || neuronet_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						neuronet_show_layout( neuronet_customizer_partial_refresh_front_page_title_button1_link() );
						neuronet_show_layout( neuronet_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
