<div class="front_page_section front_page_section_testimonials<?php
	$neuronet_scheme = neuronet_get_theme_option( 'front_page_testimonials_scheme' );
	if ( ! empty( $neuronet_scheme ) && ! neuronet_is_inherit( $neuronet_scheme ) ) {
		echo ' scheme_' . esc_attr( $neuronet_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( neuronet_get_theme_option( 'front_page_testimonials_paddings' ) );
	if ( neuronet_get_theme_option( 'front_page_testimonials_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$neuronet_css      = '';
		$neuronet_bg_image = neuronet_get_theme_option( 'front_page_testimonials_bg_image' );
		if ( ! empty( $neuronet_bg_image ) ) {
			$neuronet_css .= 'background-image: url(' . esc_url( neuronet_get_attachment_url( $neuronet_bg_image ) ) . ');';
		}
		if ( ! empty( $neuronet_css ) ) {
			echo ' style="' . esc_attr( $neuronet_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$neuronet_anchor_icon = neuronet_get_theme_option( 'front_page_testimonials_anchor_icon' );
	$neuronet_anchor_text = neuronet_get_theme_option( 'front_page_testimonials_anchor_text' );
if ( ( ! empty( $neuronet_anchor_icon ) || ! empty( $neuronet_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_testimonials"'
									. ( ! empty( $neuronet_anchor_icon ) ? ' icon="' . esc_attr( $neuronet_anchor_icon ) . '"' : '' )
									. ( ! empty( $neuronet_anchor_text ) ? ' title="' . esc_attr( $neuronet_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_testimonials_inner
	<?php
	if ( neuronet_get_theme_option( 'front_page_testimonials_fullheight' ) ) {
		echo ' neuronet-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$neuronet_css      = '';
			$neuronet_bg_mask  = neuronet_get_theme_option( 'front_page_testimonials_bg_mask' );
			$neuronet_bg_color_type = neuronet_get_theme_option( 'front_page_testimonials_bg_color_type' );
			if ( 'custom' == $neuronet_bg_color_type ) {
				$neuronet_bg_color = neuronet_get_theme_option( 'front_page_testimonials_bg_color' );
			} elseif ( 'scheme_bg_color' == $neuronet_bg_color_type ) {
				$neuronet_bg_color = neuronet_get_scheme_color( 'bg_color', $neuronet_scheme );
			} else {
				$neuronet_bg_color = '';
			}
			if ( ! empty( $neuronet_bg_color ) && $neuronet_bg_mask > 0 ) {
				$neuronet_css .= 'background-color: ' . esc_attr(
					1 == $neuronet_bg_mask ? $neuronet_bg_color : neuronet_hex2rgba( $neuronet_bg_color, $neuronet_bg_mask )
				) . ';';
			}
			if ( ! empty( $neuronet_css ) ) {
				echo ' style="' . esc_attr( $neuronet_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_testimonials_content_wrap content_wrap">
			<?php
			// Caption
			$neuronet_caption = neuronet_get_theme_option( 'front_page_testimonials_caption' );
			if ( ! empty( $neuronet_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_testimonials_caption front_page_block_<?php echo ! empty( $neuronet_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $neuronet_caption, 'neuronet_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$neuronet_description = neuronet_get_theme_option( 'front_page_testimonials_description' );
			if ( ! empty( $neuronet_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_testimonials_description front_page_block_<?php echo ! empty( $neuronet_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $neuronet_description ), 'neuronet_kses_content' ); ?></div>
				<?php
			}

			// Content (widgets)
			?>
			<div class="front_page_section_output front_page_section_testimonials_output">
				<?php
				if ( is_active_sidebar( 'front_page_testimonials_widgets' ) ) {
					dynamic_sidebar( 'front_page_testimonials_widgets' );
				} elseif ( current_user_can( 'edit_theme_options' ) ) {
					if ( ! neuronet_exists_trx_addons() ) {
						neuronet_customizer_need_trx_addons_message();
					} else {
						neuronet_customizer_need_widgets_message( 'front_page_testimonials_caption', 'ThemeREX Addons - Testimonials' );
					}
				}
				?>
			</div>
		</div>
	</div>
</div>
