<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package NEURONET
 * @since NEURONET 1.0
 */

							do_action( 'neuronet_action_page_content_end_text' );
							
							// Widgets area below the content
							neuronet_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'neuronet_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'neuronet_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'neuronet_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'neuronet_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$neuronet_body_style = neuronet_get_theme_option( 'body_style' );
					$neuronet_widgets_name = neuronet_get_theme_option( 'widgets_below_page' );
					$neuronet_show_widgets = ! neuronet_is_off( $neuronet_widgets_name ) && is_active_sidebar( $neuronet_widgets_name );
					$neuronet_show_related = neuronet_is_single() && neuronet_get_theme_option( 'related_position' ) == 'below_page';
					if ( $neuronet_show_widgets || $neuronet_show_related ) {
						if ( 'fullscreen' != $neuronet_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $neuronet_show_related ) {
							do_action( 'neuronet_action_related_posts' );
						}

						// Widgets area below page content
						if ( $neuronet_show_widgets ) {
							neuronet_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $neuronet_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'neuronet_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'neuronet_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! neuronet_is_singular( 'post' ) && ! neuronet_is_singular( 'attachment' ) ) || ! in_array ( neuronet_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="neuronet_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'neuronet_action_before_footer' );

				// Footer
				$neuronet_footer_type = neuronet_get_theme_option( 'footer_type' );
				if ( 'custom' == $neuronet_footer_type && ! neuronet_is_layouts_available() ) {
					$neuronet_footer_type = 'default';
				}
				get_template_part( apply_filters( 'neuronet_filter_get_template_part', "templates/footer-" . sanitize_file_name( $neuronet_footer_type ) ) );

				do_action( 'neuronet_action_after_footer' );

			}
			?>

			<?php do_action( 'neuronet_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'neuronet_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'neuronet_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>