<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package INTEGRO
 * @since INTEGRO 1.0
 */

$integro_args = get_query_var( 'integro_logo_args' );

// Site logo
$integro_logo_type   = isset( $integro_args['type'] ) ? $integro_args['type'] : '';
$integro_logo_image  = integro_get_logo_image( $integro_logo_type );
$integro_logo_text   = integro_is_on( integro_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$integro_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $integro_logo_image['logo'] ) || ! empty( $integro_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $integro_logo_image['logo'] ) ) {
			if ( empty( $integro_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($integro_logo_image['logo']) && (int) $integro_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$integro_attr = integro_getimagesize( $integro_logo_image['logo'] );
				echo '<img src="' . esc_url( $integro_logo_image['logo'] ) . '"'
						. ( ! empty( $integro_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $integro_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $integro_logo_text ) . '"'
						. ( ! empty( $integro_attr[3] ) ? ' ' . wp_kses_data( $integro_attr[3] ) : '' )
						. '>';
			}
		} else {
			integro_show_layout( integro_prepare_macros( $integro_logo_text ), '<span class="logo_text">', '</span>' );
			integro_show_layout( integro_prepare_macros( $integro_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
