<?php
/**
 * The template to display default site header
 *
 * @package INTEGRO
 * @since INTEGRO 1.0
 */

$integro_header_css   = '';
$integro_header_image = get_header_image();
$integro_header_video = integro_get_header_video();
if ( ! empty( $integro_header_image ) && integro_trx_addons_featured_image_override( is_singular() || integro_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$integro_header_image = integro_get_current_mode_image( $integro_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $integro_header_image ) || ! empty( $integro_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $integro_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $integro_header_image ) {
		echo ' ' . esc_attr( integro_add_inline_css_class( 'background-image: url(' . esc_url( $integro_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( integro_is_on( integro_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight integro-full-height';
	}
	$integro_header_scheme = integro_get_theme_option( 'header_scheme' );
	if ( ! empty( $integro_header_scheme ) && ! integro_is_inherit( $integro_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $integro_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $integro_header_video ) ) {
		get_template_part( apply_filters( 'integro_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'integro_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( integro_is_on( integro_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'integro_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'integro_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'integro_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
