<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package INTEGRO
 * @since INTEGRO 1.0.06
 */

$integro_header_css   = '';
$integro_header_image = get_header_image();
$integro_header_video = integro_get_header_video();
if ( ! empty( $integro_header_image ) && integro_trx_addons_featured_image_override( is_singular() || integro_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$integro_header_image = integro_get_current_mode_image( $integro_header_image );
}

$integro_header_id = integro_get_custom_header_id();
$integro_header_meta = get_post_meta( $integro_header_id, 'trx_addons_options', true );
if ( ! empty( $integro_header_meta['margin'] ) ) {
	integro_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( integro_prepare_css_value( $integro_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $integro_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $integro_header_id ) ) ); ?>
				<?php
				echo ! empty( $integro_header_image ) || ! empty( $integro_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $integro_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $integro_header_image ) {
					echo ' ' . esc_attr( integro_add_inline_css_class( 'background-image: url(' . esc_url( $integro_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( integro_is_on( integro_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight integro-full-height';
				}
				$integro_header_scheme = integro_get_theme_option( 'header_scheme' );
				if ( ! empty( $integro_header_scheme ) && ! integro_is_inherit( $integro_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $integro_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $integro_header_video ) ) {
		get_template_part( apply_filters( 'integro_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'integro_action_show_layout', $integro_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'integro_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
