<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package INTEGRO
 * @since INTEGRO 1.0.10
 */

// Footer sidebar
$integro_footer_name    = integro_get_theme_option( 'footer_widgets' );
$integro_footer_present = ! integro_is_off( $integro_footer_name ) && is_active_sidebar( $integro_footer_name );
if ( $integro_footer_present ) {
	integro_storage_set( 'current_sidebar', 'footer' );
	$integro_footer_wide = integro_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $integro_footer_name ) ) {
		dynamic_sidebar( $integro_footer_name );
	}
	$integro_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $integro_out ) ) {
		$integro_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $integro_out );
		$integro_need_columns = true;   //or check: strpos($integro_out, 'columns_wrap')===false;
		if ( $integro_need_columns ) {
			$integro_columns = max( 0, (int) integro_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $integro_columns ) {
				$integro_columns = min( 4, max( 1, integro_tags_count( $integro_out, 'aside' ) ) );
			}
			if ( $integro_columns > 1 ) {
				$integro_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $integro_columns ) . ' widget', $integro_out );
			} else {
				$integro_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $integro_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'integro_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $integro_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $integro_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'integro_action_before_sidebar', 'footer' );
				integro_show_layout( $integro_out );
				do_action( 'integro_action_after_sidebar', 'footer' );
				if ( $integro_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $integro_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'integro_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
