<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package INTEGRO
 * @since INTEGRO 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$integro_copyright_scheme = integro_get_theme_option( 'copyright_scheme' );
if ( ! empty( $integro_copyright_scheme ) && ! integro_is_inherit( $integro_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $integro_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$integro_copyright = integro_get_theme_option( 'copyright' );
			if ( ! empty( $integro_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$integro_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $integro_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$integro_copyright = integro_prepare_macros( $integro_copyright );
				// Display copyright
				echo wp_kses( nl2br( $integro_copyright ), 'integro_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
