<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package INTEGRO
 * @since INTEGRO 1.0
 */

$integro_template_args = get_query_var( 'integro_template_args' );
if ( is_array( $integro_template_args ) ) {
	$integro_columns    = empty( $integro_template_args['columns'] ) ? 2 : max( 1, $integro_template_args['columns'] );
	$integro_blog_style = array( $integro_template_args['type'], $integro_columns );
    $integro_columns_class = integro_get_column_class( 1, $integro_columns, ! empty( $integro_template_args['columns_tablet']) ? $integro_template_args['columns_tablet'] : '', ! empty($integro_template_args['columns_mobile']) ? $integro_template_args['columns_mobile'] : '' );
} else {
	$integro_template_args = array();
	$integro_blog_style = explode( '_', integro_get_theme_option( 'blog_style' ) );
	$integro_columns    = empty( $integro_blog_style[1] ) ? 2 : max( 1, $integro_blog_style[1] );
    $integro_columns_class = integro_get_column_class( 1, $integro_columns );
}

$integro_post_format = get_post_format();
$integro_post_format = empty( $integro_post_format ) ? 'standard' : str_replace( 'post-format-', '', $integro_post_format );

?><div class="
<?php
if ( ! empty( $integro_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( integro_is_blog_style_use_masonry( $integro_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $integro_columns ) : esc_attr( $integro_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $integro_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $integro_columns )
		. ( 'portfolio' != $integro_blog_style[0] ? ' ' . esc_attr( $integro_blog_style[0] )  . '_' . esc_attr( $integro_columns ) : '' )
	);
	integro_add_blog_animation( $integro_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$integro_hover   = ! empty( $integro_template_args['hover'] ) && ! integro_is_inherit( $integro_template_args['hover'] )
								? $integro_template_args['hover']
								: integro_get_theme_option( 'image_hover' );

	if ( 'dots' == $integro_hover ) {
		$integro_post_link = empty( $integro_template_args['no_links'] )
								? ( ! empty( $integro_template_args['link'] )
									? $integro_template_args['link']
									: get_permalink()
									)
								: '';
		$integro_target    = ! empty( $integro_post_link ) && false === strpos( $integro_post_link, home_url() )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$integro_components = ! empty( $integro_template_args['meta_parts'] )
							? ( is_array( $integro_template_args['meta_parts'] )
								? $integro_template_args['meta_parts']
								: explode( ',', $integro_template_args['meta_parts'] )
								)
							: integro_array_get_keys_by_value( integro_get_theme_option( 'meta_parts' ) );

	// Featured image
	integro_show_post_featured( apply_filters( 'integro_filter_args_featured',
		array(
			'hover'         => $integro_hover,
			'no_links'      => ! empty( $integro_template_args['no_links'] ),
			'thumb_size'    => ! empty( $integro_template_args['thumb_size'] )
								? $integro_template_args['thumb_size']
								: integro_get_thumb_size(
									integro_is_blog_style_use_masonry( $integro_blog_style[0] )
										? (	strpos( integro_get_theme_option( 'body_style' ), 'full' ) !== false || $integro_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( integro_get_theme_option( 'body_style' ), 'full' ) !== false || $integro_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => integro_is_blog_style_use_masonry( $integro_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $integro_components,
			'class'         => 'dots' == $integro_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $integro_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $integro_post_link )
												? '<a href="' . esc_url( $integro_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $integro_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $integro_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $integro_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!