<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package INTEGRO
 * @since INTEGRO 1.0
 */

$integro_template_args = get_query_var( 'integro_template_args' );
$integro_columns = 1;
if ( is_array( $integro_template_args ) ) {
	$integro_columns    = empty( $integro_template_args['columns'] ) ? 1 : max( 1, $integro_template_args['columns'] );
	$integro_blog_style = array( $integro_template_args['type'], $integro_columns );
	if ( ! empty( $integro_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $integro_columns > 1 ) {
	    $integro_columns_class = integro_get_column_class( 1, $integro_columns, ! empty( $integro_template_args['columns_tablet']) ? $integro_template_args['columns_tablet'] : '', ! empty($integro_template_args['columns_mobile']) ? $integro_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $integro_columns_class ); ?>">
		<?php
	}
} else {
	$integro_template_args = array();
}
$integro_expanded    = ! integro_sidebar_present() && integro_get_theme_option( 'expand_content' ) == 'expand';
$integro_post_format = get_post_format();
$integro_post_format = empty( $integro_post_format ) ? 'standard' : str_replace( 'post-format-', '', $integro_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $integro_post_format ) );
	integro_add_blog_animation( $integro_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$integro_hover      = ! empty( $integro_template_args['hover'] ) && ! integro_is_inherit( $integro_template_args['hover'] )
							? $integro_template_args['hover']
							: integro_get_theme_option( 'image_hover' );
	$integro_components = ! empty( $integro_template_args['meta_parts'] )
							? ( is_array( $integro_template_args['meta_parts'] )
								? $integro_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $integro_template_args['meta_parts'] ) )
								)
							: integro_array_get_keys_by_value( integro_get_theme_option( 'meta_parts' ) );
	integro_show_post_featured( apply_filters( 'integro_filter_args_featured',
		array(
			'no_links'   => ! empty( $integro_template_args['no_links'] ),
			'hover'      => $integro_hover,
			'meta_parts' => $integro_components,
			'thumb_size' => ! empty( $integro_template_args['thumb_size'] )
							? $integro_template_args['thumb_size']
							: integro_get_thumb_size( strpos( integro_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $integro_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$integro_template_args
	) );

	// Title and post meta
	$integro_show_title = get_the_title() != '';
	$integro_show_meta  = count( $integro_components ) > 0 && ! in_array( $integro_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $integro_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'integro_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'integro_action_before_post_title' );
				if ( empty( $integro_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'integro_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'integro_filter_show_blog_excerpt', empty( $integro_template_args['hide_excerpt'] ) && integro_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'integro_filter_show_blog_meta', $integro_show_meta, $integro_components, 'excerpt' ) ) {
				if ( count( $integro_components ) > 0 ) {
					do_action( 'integro_action_before_post_meta' );
					integro_show_post_meta(
						apply_filters(
							'integro_filter_post_meta_args', array(
								'components' => join( ',', $integro_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'integro_action_after_post_meta' );
				}
			}

			if ( integro_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'integro_action_before_full_post_content' );
					the_content( '' );
					do_action( 'integro_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'integro' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'integro' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				integro_show_post_content( $integro_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'integro_filter_show_blog_readmore',  ! isset( $integro_template_args['more_button'] ) || ! empty( $integro_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $integro_template_args['no_links'] ) ) {
					do_action( 'integro_action_before_post_readmore' );
					if ( integro_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						integro_show_post_more_link( $integro_template_args, '<p>', '</p>' );
					} else {
						integro_show_post_comments_link( $integro_template_args, '<p>', '</p>' );
					}
					do_action( 'integro_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $integro_template_args ) ) {
	if ( ! empty( $integro_template_args['slider'] ) || $integro_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
