<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package INTEGRO
 * @since INTEGRO 1.71.0
 */

$integro_template_args = get_query_var( 'integro_template_args' );
if ( ! is_array( $integro_template_args ) ) {
	$integro_template_args = array(
								'type'    => 'band',
								'columns' => 1
								);
}

$integro_columns       = 1;

$integro_expanded      = ! integro_sidebar_present() && integro_get_theme_option( 'expand_content' ) == 'expand';

$integro_post_format   = get_post_format();
$integro_post_format   = empty( $integro_post_format ) ? 'standard' : str_replace( 'post-format-', '', $integro_post_format );

if ( is_array( $integro_template_args ) ) {
	$integro_columns    = empty( $integro_template_args['columns'] ) ? 1 : max( 1, $integro_template_args['columns'] );
	$integro_blog_style = array( $integro_template_args['type'], $integro_columns );
	if ( ! empty( $integro_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $integro_columns > 1 ) {
	    $integro_columns_class = integro_get_column_class( 1, $integro_columns, ! empty( $integro_template_args['columns_tablet']) ? $integro_template_args['columns_tablet'] : '', ! empty($integro_template_args['columns_mobile']) ? $integro_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $integro_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $integro_post_format ) );
	integro_add_blog_animation( $integro_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$integro_hover      = ! empty( $integro_template_args['hover'] ) && ! integro_is_inherit( $integro_template_args['hover'] )
							? $integro_template_args['hover']
							: integro_get_theme_option( 'image_hover' );
	$integro_components = ! empty( $integro_template_args['meta_parts'] )
							? ( is_array( $integro_template_args['meta_parts'] )
								? $integro_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $integro_template_args['meta_parts'] ) )
								)
							: integro_array_get_keys_by_value( integro_get_theme_option( 'meta_parts' ) );
	integro_show_post_featured( apply_filters( 'integro_filter_args_featured',
		array(
			'no_links'   => ! empty( $integro_template_args['no_links'] ),
			'hover'      => $integro_hover,
			'meta_parts' => $integro_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $integro_template_args['thumb_size'] )
								? $integro_template_args['thumb_size']
								: integro_get_thumb_size( 
								in_array( $integro_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( integro_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $integro_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$integro_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$integro_show_title = get_the_title() != '';
		$integro_show_meta  = count( $integro_components ) > 0 && ! in_array( $integro_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $integro_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'integro_filter_show_blog_categories', $integro_show_meta && in_array( 'categories', $integro_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'integro_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						integro_show_post_meta( apply_filters(
															'integro_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $integro_hover, 1
															)
											);
						?>
					</div>
					<?php
					$integro_components = integro_array_delete_by_value( $integro_components, 'categories' );
					do_action( 'integro_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'integro_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'integro_action_before_post_title' );
					if ( empty( $integro_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'integro_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $integro_template_args['excerpt_length'] ) && ! in_array( $integro_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$integro_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'integro_filter_show_blog_excerpt', empty( $integro_template_args['hide_excerpt'] ) && integro_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				integro_show_post_content( $integro_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'integro_filter_show_blog_meta', $integro_show_meta, $integro_components, 'band' ) ) {
			if ( count( $integro_components ) > 0 ) {
				do_action( 'integro_action_before_post_meta' );
				integro_show_post_meta(
					apply_filters(
						'integro_filter_post_meta_args', array(
							'components' => join( ',', $integro_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'integro_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'integro_filter_show_blog_readmore', ! $integro_show_title || ! empty( $integro_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $integro_template_args['no_links'] ) ) {
				do_action( 'integro_action_before_post_readmore' );
				integro_show_post_more_link( $integro_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'integro_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $integro_template_args ) ) {
	if ( ! empty( $integro_template_args['slider'] ) || $integro_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
