<?php
/**
 * The template to display single post
 *
 * @package INTEGRO
 * @since INTEGRO 1.0
 */

// Full post loading
$full_post_loading          = integro_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = integro_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = integro_get_theme_option( 'posts_navigation_scroll_which_block' );

// Position of the related posts
$integro_related_position   = integro_get_theme_option( 'related_position' );

// Type of the prev/next post navigation
$integro_posts_navigation   = integro_get_theme_option( 'posts_navigation' );
$integro_prev_post          = false;
$integro_prev_post_same_cat = integro_get_theme_option( 'posts_navigation_scroll_same_cat' );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( integro_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	integro_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'integro_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $integro_posts_navigation ) {
		$integro_prev_post = get_previous_post( $integro_prev_post_same_cat );  // Get post from same category
		if ( ! $integro_prev_post && $integro_prev_post_same_cat ) {
			$integro_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $integro_prev_post ) {
			$integro_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $integro_prev_post ) ) {
		integro_sc_layouts_showed( 'featured', false );
		integro_sc_layouts_showed( 'title', false );
		integro_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $integro_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'integro_filter_get_template_part', 'templates/content', 'single-' . integro_get_theme_option( 'single_style' ) ), 'single-' . integro_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $integro_related_position, 'inside' ) === 0 ) {
		$integro_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'integro_action_related_posts' );
		$integro_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $integro_related_content ) ) {
			$integro_related_position_inside = max( 0, min( 9, integro_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $integro_related_position_inside ) {
				$integro_related_position_inside = mt_rand( 1, 9 );
			}

			$integro_p_number         = 0;
			$integro_related_inserted = false;
			$integro_in_block         = false;
			$integro_content_start    = strpos( $integro_content, '<div class="post_content' );
			$integro_content_end      = strrpos( $integro_content, '</div>' );

			for ( $i = max( 0, $integro_content_start ); $i < min( strlen( $integro_content ) - 3, $integro_content_end ); $i++ ) {
				if ( $integro_content[ $i ] != '<' ) {
					continue;
				}
				if ( $integro_in_block ) {
					if ( strtolower( substr( $integro_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$integro_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $integro_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $integro_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$integro_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $integro_content[ $i + 1 ] && in_array( $integro_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$integro_p_number++;
					if ( $integro_related_position_inside == $integro_p_number ) {
						$integro_related_inserted = true;
						$integro_content = ( $i > 0 ? substr( $integro_content, 0, $i ) : '' )
											. $integro_related_content
											. substr( $integro_content, $i );
					}
				}
			}
			if ( ! $integro_related_inserted ) {
				if ( $integro_content_end > 0 ) {
					$integro_content = substr( $integro_content, 0, $integro_content_end ) . $integro_related_content . substr( $integro_content, $integro_content_end );
				} else {
					$integro_content .= $integro_related_content;
				}
			}
		}

		integro_show_layout( $integro_content );
	}

	// Comments
	do_action( 'integro_action_before_comments' );
	comments_template();
	do_action( 'integro_action_after_comments' );

	// Related posts
	if ( 'below_content' == $integro_related_position
		&& ( 'scroll' != $integro_posts_navigation || integro_get_theme_option( 'posts_navigation_scroll_hide_related' ) == 0 )
		&& ( ! $full_post_loading || integro_get_theme_option( 'open_full_post_hide_related' ) == 0 )
	) {
		do_action( 'integro_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $integro_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $integro_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $integro_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $integro_prev_post ) ); ?>"
			<?php do_action( 'integro_action_nav_links_single_scroll_data', $integro_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
