<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package INTEGRO
 * @since INTEGRO 1.0
 */

if ( integro_sidebar_present() ) {
	
	$integro_sidebar_type = integro_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $integro_sidebar_type && ! integro_is_layouts_available() ) {
		$integro_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $integro_sidebar_type ) {
		// Default sidebar with widgets
		$integro_sidebar_name = integro_get_theme_option( 'sidebar_widgets' );
		integro_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $integro_sidebar_name ) ) {
			dynamic_sidebar( $integro_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$integro_sidebar_id = integro_get_custom_sidebar_id();
		do_action( 'integro_action_show_layout', $integro_sidebar_id );
	}
	$integro_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $integro_out ) ) {
		$integro_sidebar_position    = integro_get_theme_option( 'sidebar_position' );
		$integro_sidebar_position_ss = integro_get_theme_option( 'sidebar_position_ss' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $integro_sidebar_position );
			echo ' sidebar_' . esc_attr( $integro_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $integro_sidebar_type );

			$integro_sidebar_scheme = apply_filters( 'integro_filter_sidebar_scheme', integro_get_theme_option( 'sidebar_scheme' ) );
			if ( ! empty( $integro_sidebar_scheme ) && ! integro_is_inherit( $integro_sidebar_scheme ) && 'custom' != $integro_sidebar_type ) {
				echo ' scheme_' . esc_attr( $integro_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="integro_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'integro_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $integro_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$integro_title = apply_filters( 'integro_filter_sidebar_control_title', 'float' == $integro_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'integro' ) : '' );
				$integro_text  = apply_filters( 'integro_filter_sidebar_control_text', 'above' == $integro_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'integro' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $integro_title ); ?>"><?php echo esc_html( $integro_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'integro_action_before_sidebar', 'sidebar' );
				integro_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $integro_out ) );
				do_action( 'integro_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'integro_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
