<?php
/**
 * The Header: Logo and main menu
 *
 * @package INTEGRO
 * @since INTEGRO 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( integro_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'integro_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'integro_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('integro_action_body_wrap_attributes'); ?>>

		<?php do_action( 'integro_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'integro_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('integro_action_page_wrap_attributes'); ?>>

			<?php do_action( 'integro_action_page_wrap_start' ); ?>

			<?php
			$integro_full_post_loading = ( integro_is_singular( 'post' ) || integro_is_singular( 'attachment' ) ) && integro_get_value_gp( 'action' ) == 'full_post_loading';
			$integro_prev_post_loading = ( integro_is_singular( 'post' ) || integro_is_singular( 'attachment' ) ) && integro_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $integro_full_post_loading && ! $integro_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="integro_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'integro_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'integro' ); ?></a>
				<?php if ( integro_sidebar_present() ) { ?>
				<a class="integro_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'integro_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'integro' ); ?></a>
				<?php } ?>
				<a class="integro_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'integro_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'integro' ); ?></a>

				<?php
				do_action( 'integro_action_before_header' );

				// Header
				$integro_header_type = integro_get_theme_option( 'header_type' );
				if ( 'custom' == $integro_header_type && ! integro_is_layouts_available() ) {
					$integro_header_type = 'default';
				}
				get_template_part( apply_filters( 'integro_filter_get_template_part', "templates/header-" . sanitize_file_name( $integro_header_type ) ) );

				// Side menu
				if ( in_array( integro_get_theme_option( 'menu_side' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'integro_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				get_template_part( apply_filters( 'integro_filter_get_template_part', 'templates/header-navi-mobile' ) );

				do_action( 'integro_action_after_header' );

			}
			?>

			<?php do_action( 'integro_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( integro_is_off( integro_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $integro_header_type ) ) {
						$integro_header_type = integro_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $integro_header_type && integro_is_layouts_available() ) {
						$integro_header_id = integro_get_custom_header_id();
						if ( $integro_header_id > 0 ) {
							$integro_header_meta = integro_get_custom_layout_meta( $integro_header_id );
							if ( ! empty( $integro_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$integro_footer_type = integro_get_theme_option( 'footer_type' );
					if ( 'custom' == $integro_footer_type && integro_is_layouts_available() ) {
						$integro_footer_id = integro_get_custom_footer_id();
						if ( $integro_footer_id ) {
							$integro_footer_meta = integro_get_custom_layout_meta( $integro_footer_id );
							if ( ! empty( $integro_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'integro_action_page_content_wrap_class', $integro_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'integro_filter_is_prev_post_loading', $integro_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( integro_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'integro_action_page_content_wrap_data', $integro_prev_post_loading );
			?>>
				<?php
				do_action( 'integro_action_page_content_wrap', $integro_full_post_loading || $integro_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'integro_filter_single_post_header', integro_is_singular( 'post' ) || integro_is_singular( 'attachment' ) ) ) {
					if ( $integro_prev_post_loading ) {
						if ( integro_get_theme_option( 'posts_navigation_scroll_which_block' ) != 'article' ) {
							do_action( 'integro_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$integro_path = apply_filters( 'integro_filter_get_template_part', 'templates/single-styles/' . integro_get_theme_option( 'single_style' ) );
					if ( integro_get_file_dir( $integro_path . '.php' ) != '' ) {
						get_template_part( $integro_path );
					}
				}

				// Widgets area above page
				$integro_body_style   = integro_get_theme_option( 'body_style' );
				$integro_widgets_name = integro_get_theme_option( 'widgets_above_page' );
				$integro_show_widgets = ! integro_is_off( $integro_widgets_name ) && is_active_sidebar( $integro_widgets_name );
				if ( $integro_show_widgets ) {
					if ( 'fullscreen' != $integro_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					integro_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $integro_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'integro_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $integro_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'integro_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'integro_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="integro_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( integro_is_singular( 'post' ) || integro_is_singular( 'attachment' ) )
							&& $integro_prev_post_loading 
							&& integro_get_theme_option( 'posts_navigation_scroll_which_block' ) == 'article'
						) {
							do_action( 'integro_action_between_posts' );
						}

						// Widgets area above content
						integro_create_widgets_area( 'widgets_above_content' );

						do_action( 'integro_action_page_content_start_text' );
