<div class="front_page_section front_page_section_googlemap<?php
	$integro_scheme = integro_get_theme_option( 'front_page_googlemap_scheme' );
	if ( ! empty( $integro_scheme ) && ! integro_is_inherit( $integro_scheme ) ) {
		echo ' scheme_' . esc_attr( $integro_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( integro_get_theme_option( 'front_page_googlemap_paddings' ) );
	if ( integro_get_theme_option( 'front_page_googlemap_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$integro_css      = '';
		$integro_bg_image = integro_get_theme_option( 'front_page_googlemap_bg_image' );
		if ( ! empty( $integro_bg_image ) ) {
			$integro_css .= 'background-image: url(' . esc_url( integro_get_attachment_url( $integro_bg_image ) ) . ');';
		}
		if ( ! empty( $integro_css ) ) {
			echo ' style="' . esc_attr( $integro_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$integro_anchor_icon = integro_get_theme_option( 'front_page_googlemap_anchor_icon' );
	$integro_anchor_text = integro_get_theme_option( 'front_page_googlemap_anchor_text' );
if ( ( ! empty( $integro_anchor_icon ) || ! empty( $integro_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_googlemap"'
									. ( ! empty( $integro_anchor_icon ) ? ' icon="' . esc_attr( $integro_anchor_icon ) . '"' : '' )
									. ( ! empty( $integro_anchor_text ) ? ' title="' . esc_attr( $integro_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_googlemap_inner
		<?php
		$integro_layout = integro_get_theme_option( 'front_page_googlemap_layout' );
		echo ' front_page_section_layout_' . esc_attr( $integro_layout );
		if ( integro_get_theme_option( 'front_page_googlemap_fullheight' ) ) {
			echo ' integro-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
		"
			<?php
			$integro_css      = '';
			$integro_bg_mask  = integro_get_theme_option( 'front_page_googlemap_bg_mask' );
			$integro_bg_color_type = integro_get_theme_option( 'front_page_googlemap_bg_color_type' );
			if ( 'custom' == $integro_bg_color_type ) {
				$integro_bg_color = integro_get_theme_option( 'front_page_googlemap_bg_color' );
			} elseif ( 'scheme_bg_color' == $integro_bg_color_type ) {
				$integro_bg_color = integro_get_scheme_color( 'bg_color', $integro_scheme );
			} else {
				$integro_bg_color = '';
			}
			if ( ! empty( $integro_bg_color ) && $integro_bg_mask > 0 ) {
				$integro_css .= 'background-color: ' . esc_attr(
					1 == $integro_bg_mask ? $integro_bg_color : integro_hex2rgba( $integro_bg_color, $integro_bg_mask )
				) . ';';
			}
			if ( ! empty( $integro_css ) ) {
				echo ' style="' . esc_attr( $integro_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_googlemap_content_wrap
		<?php
		if ( 'fullwidth' != $integro_layout ) {
			echo ' content_wrap';
		}
		?>
		">
			<?php
			// Content wrap with title and description
			$integro_caption     = integro_get_theme_option( 'front_page_googlemap_caption' );
			$integro_description = integro_get_theme_option( 'front_page_googlemap_description' );
			if ( ! empty( $integro_caption ) || ! empty( $integro_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'fullwidth' == $integro_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}
					// Caption
				if ( ! empty( $integro_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_googlemap_caption front_page_block_<?php echo ! empty( $integro_caption ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $integro_caption, 'integro_kses_content' );
					?>
					</h2>
					<?php
				}

					// Description (text)
				if ( ! empty( $integro_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_googlemap_description front_page_block_<?php echo ! empty( $integro_description ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( wpautop( $integro_description ), 'integro_kses_content' );
					?>
					</div>
					<?php
				}
				if ( 'fullwidth' == $integro_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$integro_content = integro_get_theme_option( 'front_page_googlemap_content' );
			if ( ! empty( $integro_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'columns' == $integro_layout ) {
					?>
					<div class="front_page_section_columns front_page_section_googlemap_columns columns_wrap">
						<div class="column-1_3">
					<?php
				} elseif ( 'fullwidth' == $integro_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}

				?>
				<div class="front_page_section_content front_page_section_googlemap_content front_page_block_<?php echo ! empty( $integro_content ) ? 'filled' : 'empty'; ?>">
				<?php
					echo wp_kses( $integro_content, 'integro_kses_content' );
				?>
				</div>
				<?php

				if ( 'columns' == $integro_layout ) {
					?>
					</div><div class="column-2_3">
					<?php
				} elseif ( 'fullwidth' == $integro_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Widgets output
			?>
			<div class="front_page_section_output front_page_section_googlemap_output">
				<?php
				if ( is_active_sidebar( 'front_page_googlemap_widgets' ) ) {
					dynamic_sidebar( 'front_page_googlemap_widgets' );
				} elseif ( current_user_can( 'edit_theme_options' ) ) {
					if ( ! integro_exists_trx_addons() ) {
						integro_customizer_need_trx_addons_message();
					} else {
						integro_customizer_need_widgets_message( 'front_page_googlemap_caption', 'ThemeREX Addons - Google map' );
					}
				}
				?>
			</div>
			<?php

			if ( 'columns' == $integro_layout && ( ! empty( $integro_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>
		</div>
	</div>
</div>
