<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package INTEGRO
 * @since INTEGRO 1.0
 */

							do_action( 'integro_action_page_content_end_text' );
							
							// Widgets area below the content
							integro_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'integro_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'integro_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'integro_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'integro_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$integro_body_style = integro_get_theme_option( 'body_style' );
					$integro_widgets_name = integro_get_theme_option( 'widgets_below_page' );
					$integro_show_widgets = ! integro_is_off( $integro_widgets_name ) && is_active_sidebar( $integro_widgets_name );
					$integro_show_related = integro_is_single() && integro_get_theme_option( 'related_position' ) == 'below_page';
					if ( $integro_show_widgets || $integro_show_related ) {
						if ( 'fullscreen' != $integro_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $integro_show_related ) {
							do_action( 'integro_action_related_posts' );
						}

						// Widgets area below page content
						if ( $integro_show_widgets ) {
							integro_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $integro_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'integro_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'integro_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! integro_is_singular( 'post' ) && ! integro_is_singular( 'attachment' ) ) || ! in_array ( integro_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="integro_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'integro_action_before_footer' );

				// Footer
				$integro_footer_type = integro_get_theme_option( 'footer_type' );
				if ( 'custom' == $integro_footer_type && ! integro_is_layouts_available() ) {
					$integro_footer_type = 'default';
				}
				get_template_part( apply_filters( 'integro_filter_get_template_part', "templates/footer-" . sanitize_file_name( $integro_footer_type ) ) );

				do_action( 'integro_action_after_footer' );

			}
			?>

			<?php do_action( 'integro_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'integro_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'integro_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>